/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.generator;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.valueobjects.generator.JavaTypesGenerator;
import de.cuioss.test.valueobjects.generator.dynamic.impl.CollectionTypeGenerator;
import de.cuioss.test.valueobjects.property.util.CollectionType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public final class TypedGeneratorRegistry {
    private static final String GENERATOR_MUST_NOT_BE_NULL = "generator must not be null";
    private static final String TYPE_MUST_NOT_BE_NULL = "type must not be null";
    private static final Map<Class<?>, TypedGenerator<?>> REGISTRY = new ConcurrentHashMap();

    public static boolean containsGenerator(Class<?> type) {
        Objects.requireNonNull(type, TYPE_MUST_NOT_BE_NULL);
        return REGISTRY.containsKey(type);
    }

    public static <T> Optional<TypedGenerator<T>> getGenerator(Class<T> type) {
        Objects.requireNonNull(type, TYPE_MUST_NOT_BE_NULL);
        if (!REGISTRY.containsKey(type)) {
            return Optional.empty();
        }
        return Optional.of(REGISTRY.get(type));
    }

    public static <T> void registerGenerator(TypedGenerator<T> typedGenerator) {
        Objects.requireNonNull(typedGenerator, GENERATOR_MUST_NOT_BE_NULL);
        REGISTRY.put(typedGenerator.getType(), typedGenerator);
    }

    public static void registerTypedGenerator(Class<?> type, TypedGenerator<?> generator) {
        Objects.requireNonNull(type, TYPE_MUST_NOT_BE_NULL);
        Objects.requireNonNull(generator, GENERATOR_MUST_NOT_BE_NULL);
        REGISTRY.put(type, generator);
    }

    public static <T> void removeGenerator(Class<T> type) {
        Objects.requireNonNull(type, TYPE_MUST_NOT_BE_NULL);
        REGISTRY.remove(type);
    }

    public static void clear() {
        REGISTRY.clear();
    }

    public static void registerBasicTypes() {
        JavaTypesGenerator.allGenerators().forEach(g -> REGISTRY.put(g.getType(), (TypedGenerator<?>)g));
        REGISTRY.put(Collection.class, new CollectionTypeGenerator<Collection>(Collection.class, CollectionType.COLLECTION));
        REGISTRY.put(List.class, new CollectionTypeGenerator<List>(List.class, CollectionType.LIST));
        REGISTRY.put(Set.class, new CollectionTypeGenerator<Set>(Set.class, CollectionType.SET));
        REGISTRY.put(SortedSet.class, new CollectionTypeGenerator<SortedSet>(SortedSet.class, CollectionType.SORTED_SET));
    }

    @Generated
    private TypedGeneratorRegistry() {
    }
}

