/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.generator.dynamic.impl;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.valueobjects.generator.dynamic.impl.ConstructorBasedGenerator;
import de.cuioss.tools.logging.CuiLogger;
import java.util.Optional;
import javassist.util.proxy.ProxyFactory;
import lombok.Generated;
import lombok.NonNull;

public class DynamicProxyGenerator<T>
implements TypedGenerator<T> {
    private static final CuiLogger LOGGER = new CuiLogger(DynamicProxyGenerator.class);
    @NonNull
    private final Class<T> type;
    private final TypedGenerator<T> wrappedGenerator;

    public T next() {
        return (T)this.wrappedGenerator.next();
    }

    public Class<T> getType() {
        return this.type;
    }

    public static final <T> Optional<TypedGenerator<T>> getGeneratorForType(Class<T> type) {
        if (null == type || type.isAnnotation() || type.isInterface() || type.isEnum()) {
            return Optional.empty();
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(type);
        proxyFactory.setFilter(m -> "equals".equals(m.getName()));
        Class createClassType = proxyFactory.createClass();
        Optional constructorGenerator = ConstructorBasedGenerator.getGeneratorForType(createClassType);
        if (constructorGenerator.isPresent()) {
            return Optional.of(new DynamicProxyGenerator<T>(type, constructorGenerator.get()));
        }
        LOGGER.warn("Unable to determine generator for type %s", new Object[]{type});
        return Optional.empty();
    }

    @Generated
    public String toString() {
        return "DynamicProxyGenerator(wrappedGenerator=" + String.valueOf(this.wrappedGenerator) + ")";
    }

    @Generated
    private DynamicProxyGenerator(@NonNull Class<T> type, TypedGenerator<T> wrappedGenerator) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.wrappedGenerator = wrappedGenerator;
    }
}

