/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.objects.impl;

import de.cuioss.test.valueobjects.objects.BuilderInstantiator;
import de.cuioss.test.valueobjects.objects.impl.ExceptionHelper;
import de.cuioss.tools.logging.CuiLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import lombok.Generated;

public class BuilderFactoryBasedInstantiator<T>
implements BuilderInstantiator<T> {
    private static final String UNABLE_TO_ACCESS_METHOD = "Unable to access method %s on type %s, due to %s";
    private static final CuiLogger LOGGER = new CuiLogger(BuilderFactoryBasedInstantiator.class);
    private final Method builderFactoryMethod;
    private final Method builderMethod;
    private final Class<T> targetClass;
    private final Class<?> builderClass;

    public BuilderFactoryBasedInstantiator(Class<?> enclosingType) {
        this(enclosingType, "builder", "build");
    }

    public BuilderFactoryBasedInstantiator(Class<?> enclosingType, String builderFactoryMethodName, String builderMethodName) {
        Objects.requireNonNull(enclosingType, "enclosingType must not be null");
        Objects.requireNonNull(builderMethodName, "builderMethodName must not be null");
        Objects.requireNonNull(builderFactoryMethodName, "builderFactoryMethodName must not be null");
        try {
            this.builderFactoryMethod = enclosingType.getDeclaredMethod(builderFactoryMethodName, new Class[0]);
            this.builderClass = this.builderFactoryMethod.getReturnType();
        }
        catch (NoSuchMethodException | SecurityException e) {
            String message = UNABLE_TO_ACCESS_METHOD.formatted(builderFactoryMethodName, enclosingType.getName(), ExceptionHelper.extractCauseMessageFromThrowable(e));
            LOGGER.error((Throwable)e, message);
            throw new AssertionError(message, e);
        }
        try {
            this.builderMethod = this.builderClass.getDeclaredMethod(builderMethodName, new Class[0]);
            this.targetClass = this.builderMethod.getReturnType();
        }
        catch (NoSuchMethodException | SecurityException e) {
            String message = UNABLE_TO_ACCESS_METHOD.formatted(builderMethodName, this.builderClass, ExceptionHelper.extractCauseMessageFromThrowable(e));
            LOGGER.error((Throwable)e, message);
            throw new AssertionError(message, e);
        }
    }

    @Override
    public Object newBuilderInstance() {
        try {
            return this.builderFactoryMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String message = UNABLE_TO_ACCESS_METHOD.formatted(this.builderFactoryMethod.getName(), this.targetClass, ExceptionHelper.extractCauseMessageFromThrowable(e));
            LOGGER.error((Throwable)e, message);
            throw new AssertionError(message, e);
        }
    }

    @Override
    public T build(Object builder) {
        try {
            return (T)this.builderMethod.invoke(builder, new Object[0]);
        }
        catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
            String message = UNABLE_TO_ACCESS_METHOD.formatted(this.builderMethod.getName(), this.builderClass.getName(), ExceptionHelper.extractCauseMessageFromThrowable(e));
            LOGGER.debug(message, (Throwable)e);
            throw new AssertionError(message, e);
        }
    }

    @Generated
    public String toString() {
        return "BuilderFactoryBasedInstantiator(builderFactoryMethod=" + String.valueOf(this.builderFactoryMethod) + ", builderMethod=" + String.valueOf(this.builderMethod) + ", targetClass=" + String.valueOf(this.getTargetClass()) + ", builderClass=" + String.valueOf(this.getBuilderClass()) + ")";
    }

    @Override
    @Generated
    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    @Override
    @Generated
    public Class<?> getBuilderClass() {
        return this.builderClass;
    }
}

