/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.objects.impl;

import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.objects.impl.AbstractOrderedArgsInstantiator;
import de.cuioss.test.valueobjects.objects.impl.ExceptionHelper;
import de.cuioss.tools.logging.CuiLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Objects;

public class ConstructorBasedInstantiator<T>
extends AbstractOrderedArgsInstantiator<T> {
    private final Constructor<T> constructor;
    private static final CuiLogger LOGGER = new CuiLogger(ConstructorBasedInstantiator.class);

    public ConstructorBasedInstantiator(Class<T> type, RuntimeProperties runtimeProperties) {
        super(runtimeProperties);
        Objects.requireNonNull(type);
        ArrayList parameter = new ArrayList();
        runtimeProperties.getAllProperties().forEach(meta -> parameter.add(meta.resolveActualClass()));
        try {
            this.constructor = parameter.isEmpty() ? type.getConstructor(new Class[0]) : type.getConstructor(ConstructorBasedInstantiator.toClassArray(parameter));
            Objects.requireNonNull(this.constructor, "Unable to find a constructor with signature " + String.valueOf(parameter));
        }
        catch (NoSuchMethodException | SecurityException e) {
            String message = "Unable to find a constructor with signature " + String.valueOf(parameter) + ", for type " + type.getName();
            LOGGER.error((Throwable)e, message);
            for (Constructor<?> tempConstructor : type.getConstructors()) {
                LOGGER.error("Found constructor: %s", new Object[]{tempConstructor.toGenericString()});
            }
            if (0 == type.getConstructors().length) {
                LOGGER.error("No public constructor found!");
            }
            throw new AssertionError((Object)message);
        }
    }

    @Override
    protected T doInstantiate(Object ... args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            String message = "Unable to invoke constructor , due to " + ExceptionHelper.extractCauseMessageFromThrowable(e);
            throw new AssertionError(message, e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "\nConstructor: " + String.valueOf(this.constructor) + "\nProperty Configuration: " + this.getRuntimeProperties().toString();
    }
}

