/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.util;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.valueobjects.api.property.PropertyConfig;
import de.cuioss.test.valueobjects.api.property.PropertyConfigs;
import de.cuioss.test.valueobjects.generator.dynamic.DynamicTypedGenerator;
import de.cuioss.test.valueobjects.objects.impl.DefaultInstantiator;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.impl.PropertyMetadataImpl;
import de.cuioss.test.valueobjects.property.util.CollectionType;
import de.cuioss.tools.collect.CollectionBuilder;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.reflect.MoreReflection;
import de.cuioss.tools.string.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import lombok.Generated;

public class PropertyHelper {
    private static final CuiLogger LOGGER = new CuiLogger(PropertyHelper.class);
    private static boolean propertyInformationLogged = false;
    private static boolean propertyTargetInformationLogged = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logMessageForPropertyMetadata(Collection<? extends PropertyMetadata> handled) {
        if (propertyInformationLogged) return;
        StringBuilder messageBuilder = new StringBuilder("Properties detected by using reflection and PropertyConfig-annotation: ").append("\n");
        ArrayList elements = new ArrayList();
        handled.forEach(data -> elements.add("-" + data.toString()));
        Collections.sort(elements);
        messageBuilder.append(Joiner.on((String)"\n").join(elements));
        LOGGER.info(messageBuilder.toString());
        Class<PropertyHelper> clazz = PropertyHelper.class;
        synchronized (PropertyHelper.class) {
            propertyInformationLogged = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logMessageForTargetPropertyMetadata(Collection<? extends PropertyMetadata> handled) {
        if (propertyTargetInformationLogged) return;
        StringBuilder messageBuilder = new StringBuilder("Properties detected for targetType: ").append("\n");
        ArrayList elements = new ArrayList();
        handled.forEach(data -> elements.add("-" + data.toString()));
        Collections.sort(elements);
        messageBuilder.append(Joiner.on((String)"\n").join(elements));
        LOGGER.info(messageBuilder.toString());
        Class<PropertyHelper> clazz = PropertyHelper.class;
        synchronized (PropertyHelper.class) {
            propertyTargetInformationLogged = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static final Collection<PropertyMetadata> handlePrimitiveAsDefaults(Collection<PropertyMetadata> metadata) {
        Objects.requireNonNull(metadata);
        if (metadata.isEmpty()) {
            return metadata;
        }
        CollectionBuilder builder = new CollectionBuilder();
        for (PropertyMetadata propertyMetadata : metadata) {
            if (propertyMetadata.getPropertyClass().isPrimitive() && CollectionType.NO_ITERABLE.equals((Object)propertyMetadata.getCollectionType())) {
                builder.add((Object)PropertyMetadataImpl.builder(propertyMetadata).defaultValue(true).build());
                continue;
            }
            builder.add((Object)propertyMetadata);
        }
        return builder.toImmutableList();
    }

    public static final Set<PropertyMetadata> handlePropertyConfigAnnotations(Class<?> annotated) {
        Objects.requireNonNull(annotated);
        return PropertyHelper.handlePropertyConfigAnnotations(PropertyHelper.extractConfiguredPropertyConfigs(annotated));
    }

    public static final Set<PropertyMetadata> handlePropertyConfigAnnotations(Collection<PropertyConfig> config) {
        CollectionBuilder builder = new CollectionBuilder();
        config.forEach(conf -> builder.add((Object)PropertyHelper.propertyConfigToPropertyMetadata(conf)));
        return builder.toImmutableSet();
    }

    public static final Set<PropertyConfig> extractConfiguredPropertyConfigs(Class<?> annotated) {
        Objects.requireNonNull(annotated);
        CollectionBuilder builder = new CollectionBuilder();
        MoreReflection.extractAllAnnotations(annotated, PropertyConfigs.class).forEach(contract -> builder.add((Object[])contract.value()));
        MoreReflection.extractAllAnnotations(annotated, PropertyConfig.class).forEach(arg_0 -> ((CollectionBuilder)builder).add(arg_0));
        return builder.toImmutableSet();
    }

    private static PropertyMetadata propertyConfigToPropertyMetadata(PropertyConfig config) {
        Class<? extends TypedGenerator> generatorClass = config.generator();
        TypedGenerator generator = !DynamicTypedGenerator.class.equals(generatorClass) ? new DefaultInstantiator<TypedGenerator>(generatorClass).newInstance() : new DynamicTypedGenerator(config.propertyClass());
        return PropertyMetadataImpl.builder().name(config.name()).defaultValue(config.defaultValue()).propertyAccessStrategy(config.propertyAccessStrategy()).generator(generator).propertyClass(config.propertyClass()).propertyMemberInfo(config.propertyMemberInfo()).collectionType(config.collectionType()).assertionStrategy(config.assertionStrategy()).propertyReadWrite(config.propertyReadWrite()).required(config.required()).build();
    }

    public static final Map<String, PropertyMetadata> toMapView(Collection<PropertyMetadata> metadata) {
        HashMap<String, PropertyMetadata> map = new HashMap<String, PropertyMetadata>();
        if (null == metadata) {
            return map;
        }
        metadata.forEach(m -> map.put(m.getName(), (PropertyMetadata)m));
        return map;
    }

    public static Map<String, PropertyMetadata> handleWhiteAndBlacklist(String[] of, String[] exclude, Collection<PropertyMetadata> givenMetadata) {
        Map<String, PropertyMetadata> map = PropertyHelper.toMapView(givenMetadata);
        if (of.length != 0) {
            HashMap<String, PropertyMetadata> copyMap = new HashMap<String, PropertyMetadata>();
            for (String name : of) {
                PropertyHelper.assertPropertyExists(name, map);
                copyMap.put(name, map.get(name));
            }
            map = copyMap;
        } else {
            for (String name : exclude) {
                map.remove(name);
            }
        }
        return map;
    }

    public static List<PropertyMetadata> handleWhiteAndBlacklistAsList(String[] of, String[] exclude, List<PropertyMetadata> givenMetadata) {
        if (null == givenMetadata || givenMetadata.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, PropertyMetadata> map = PropertyHelper.handleWhiteAndBlacklist(of, exclude, givenMetadata);
        CollectionBuilder builder = new CollectionBuilder();
        for (PropertyMetadata meta : givenMetadata) {
            if (!map.containsKey(meta.getName())) continue;
            builder.add((Object)meta);
        }
        return builder.toImmutableList();
    }

    public static void assertPropertyExists(String name, Map<String, PropertyMetadata> map) {
        if (!map.containsKey(name)) {
            throw new IllegalArgumentException("'" + name + "' is not a configured property within the given properties, check your configuration");
        }
    }

    public static void assertPropertyExists(String name, SortedSet<PropertyMetadata> givenMetadata) {
        HashMap<String, PropertyMetadata> map = new HashMap<String, PropertyMetadata>();
        givenMetadata.forEach(meta -> map.put(meta.getName(), (PropertyMetadata)meta));
        PropertyHelper.assertPropertyExists(name, map);
    }

    @Generated
    private PropertyHelper() {
    }
}

