/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

public class SamplingParameters {
    private final String counterName;
    private final String sumName;
    private final String signature;

    public SamplingParameters(String signature, int counterIndex) {
        String nameBeforeParanthesis = signature.substring(0, signature.indexOf(40));
        String methodNameSubstring = nameBeforeParanthesis.substring(nameBeforeParanthesis.lastIndexOf(46) + 1);
        if (methodNameSubstring.equals("<init>")) {
            this.counterName = "_kieker_sourceInstrumentation_initCounter" + counterIndex;
            this.sumName = "_kieker_sourceInstrumentation_initSum" + counterIndex;
        } else {
            this.counterName = "_kieker_sourceInstrumentation_" + methodNameSubstring + "Counter" + counterIndex;
            this.sumName = "_kieker_sourceInstrumentation_" + methodNameSubstring + "Sum" + counterIndex;
        }
        this.signature = signature;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public String getSumName() {
        return this.sumName;
    }

    public String getFinalBlock(String signature, int count) {
        return "// measure after\n         final long _kieker_sourceInstrumentation_tout = _kieker_sourceInstrumentation_TIME_SOURCE.getTime();\n        " + this.sumName + "+=" + "_kieker_sourceInstrumentation_" + "tout-" + "_kieker_sourceInstrumentation_" + "tin;\nif (" + this.counterName + "++%" + count + "==0){\nfinal String " + "_kieker_sourceInstrumentation_" + "signature = \"" + signature + "\";\nfinal long " + "_kieker_sourceInstrumentation_" + "calculatedTout=" + "_kieker_sourceInstrumentation_" + "tin+" + this.sumName + ";\n" + "_kieker_sourceInstrumentation_" + "controller.newMonitoringRecord(new DurationRecord(" + "_kieker_sourceInstrumentation_" + "signature, " + "_kieker_sourceInstrumentation_" + "tin, " + "_kieker_sourceInstrumentation_" + "calculatedTout));\n" + this.sumName + "=0;}\n";
    }

    public String getSignature() {
        return this.signature;
    }
}

