/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.type.Type;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import net.kieker.sourceinstrumentation.InstrumentationConfiguration;

public class KiekerFieldAdder {
    private final InstrumentationConfiguration configuration;

    public KiekerFieldAdder(InstrumentationConfiguration configuration) {
        this.configuration = configuration;
    }

    public void addKiekerFields(TypeDeclaration<?> clazz) {
        Modifier.Keyword[] keywords = this.getKeywords(clazz);
        this.addField(clazz, keywords, 0, "kieker.monitoring.core.controller.IMonitoringController", "_kieker_sourceInstrumentation_controller", (Expression)new MethodCallExpr("kieker.monitoring.core.controller.MonitoringController.getInstance", new Expression[0]));
        this.addField(clazz, keywords, 1, "kieker.monitoring.timer.ITimeSource", "_kieker_sourceInstrumentation_TIME_SOURCE", (Expression)new MethodCallExpr("_kieker_sourceInstrumentation_controller.getTimeSource", new Expression[0]));
        if (this.configuration.getUsedRecord() == AllowedKiekerRecord.OPERATIONEXECUTION) {
            this.addMetadataFields(clazz, keywords);
        }
    }

    private void addMetadataFields(TypeDeclaration<?> clazz, Modifier.Keyword[] keywords) {
        this.addField(clazz, keywords, 2, "String", "_kieker_sourceInstrumentation_VM_NAME", (Expression)new MethodCallExpr("_kieker_sourceInstrumentation_controller.getHostname", new Expression[0]));
        this.addField(clazz, keywords, 3, "kieker.monitoring.core.registry.SessionRegistry", "_kieker_sourceInstrumentation_SESSION_REGISTRY", (Expression)new FieldAccessExpr((Expression)new NameExpr("SessionRegistry"), "INSTANCE"));
        this.addField(clazz, keywords, 4, "kieker.monitoring.core.registry.ControlFlowRegistry", "_kieker_sourceInstrumentation_controlFlowRegistry", (Expression)new FieldAccessExpr((Expression)new NameExpr("ControlFlowRegistry"), "INSTANCE"));
    }

    private Modifier.Keyword[] getKeywords(TypeDeclaration<?> clazz) {
        ClassOrInterfaceDeclaration declaration;
        Modifier.Keyword[] keywords = clazz instanceof ClassOrInterfaceDeclaration ? ((declaration = (ClassOrInterfaceDeclaration)clazz).isInterface() ? new Modifier.Keyword[]{Modifier.Keyword.STATIC, Modifier.Keyword.FINAL} : new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL}) : new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL};
        return keywords;
    }

    private void addField(TypeDeclaration<?> clazz, Modifier.Keyword[] keywords, int position, String typeName, String variableName, Expression initExpression) {
        Type type = StaticJavaParser.parseType((String)typeName);
        FieldDeclaration fieldDeclaration = new FieldDeclaration();
        VariableDeclarator variable = new VariableDeclarator(type, variableName);
        fieldDeclaration.getVariables().add((Node)variable);
        fieldDeclaration.setModifiers(Modifier.createModifierList((Modifier.Keyword[])keywords));
        clazz.getMembers().add(position, (Node)fieldDeclaration);
        ((VariableDeclarator)fieldDeclaration.getVariables().iterator().next()).setInitializer(initExpression);
    }
}

