/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument.codeblocks;

import com.github.javaparser.ast.body.TypeDeclaration;

public class CodeBlockTransformer {
    private final TypeDeclaration<?> topLevelType;

    public CodeBlockTransformer(TypeDeclaration<?> topLevelType) {
        this.topLevelType = topLevelType;
    }

    public String getControllerName(boolean useStaticVariables) {
        String controllerName = useStaticVariables ? this.topLevelType.getNameAsString() + "." + "_kieker_sourceInstrumentation_" + "controller" : "kieker.monitoring.core.controller.MonitoringController.getInstance()";
        return controllerName;
    }

    public String getTransformedBlock(String originalBlock, boolean useStaticVariables) {
        String transformedBlock = useStaticVariables ? this.replaceTypeVariables(originalBlock) : CodeBlockTransformer.replaceStaticVariables(originalBlock);
        return transformedBlock;
    }

    public static String replaceStaticVariables(String original) {
        String before = original.replaceAll("_kieker_sourceInstrumentation_VM_NAME", "kieker.monitoring.core.controller.MonitoringController.getInstance().getHostname()").replaceAll("_kieker_sourceInstrumentation_SESSION_REGISTRY", "SessionRegistry.INSTANCE").replaceAll("_kieker_sourceInstrumentation_controlFlowRegistry", "ControlFlowRegistry.INSTANCE").replaceAll("_kieker_sourceInstrumentation_controller", "kieker.monitoring.core.controller.MonitoringController.getInstance()").replaceAll("_kieker_sourceInstrumentation_TIME_SOURCE", "kieker.monitoring.core.controller.MonitoringController.getInstance().getTimeSource()");
        return before;
    }

    private String replaceTypeVariables(String original) {
        String before = original.replaceAll("_kieker_sourceInstrumentation_VM_NAME", this.topLevelType.getNameAsString() + "." + "_kieker_sourceInstrumentation_" + "VM_NAME").replaceAll("_kieker_sourceInstrumentation_SESSION_REGISTRY", this.topLevelType.getNameAsString() + "." + "_kieker_sourceInstrumentation_" + "SESSION_REGISTRY").replaceAll("_kieker_sourceInstrumentation_controlFlowRegistry", this.topLevelType.getNameAsString() + "." + "_kieker_sourceInstrumentation_" + "controlFlowRegistry").replaceAll("_kieker_sourceInstrumentation_controller", this.topLevelType.getNameAsString() + "." + "_kieker_sourceInstrumentation_" + "controller").replaceAll("_kieker_sourceInstrumentation_TIME_SOURCE", this.topLevelType.getNameAsString() + "." + "_kieker_sourceInstrumentation_" + "TIME_SOURCE");
        return before;
    }

    public static String replaceStaticVariablesByClassStaticVariables(String original) {
        String before = original.replaceAll("_kieker_sourceInstrumentation_TIME_SOURCE", "_Kieker_Values._kieker_sourceInstrumentation_TIME_SOURCE").replaceAll("_kieker_sourceInstrumentation_controller", "_Kieker_Values._kieker_sourceInstrumentation_controller");
        return before;
    }
}

