/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.parseUtils;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.util.LinkedList;
import java.util.List;

public class ClazzFinder {
    public static List<String> getClazzes(Node node, String parent, String clazzSeparator) {
        LinkedList<String> clazzes = new LinkedList<String>();
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)node;
            String clazzname = parent.length() > 0 ? parent + clazzSeparator + clazz.getName().getIdentifier() : clazz.getName().getIdentifier();
            clazzes.add(clazzname);
            for (Node child : node.getChildNodes()) {
                clazzes.addAll(ClazzFinder.getClazzes(child, clazzname, clazzSeparator));
            }
        } else {
            for (Node child : node.getChildNodes()) {
                clazzes.addAll(ClazzFinder.getClazzes(child, parent, clazzSeparator));
            }
        }
        return clazzes;
    }

    public static List<String> getClazzes(CompilationUnit cu) {
        LinkedList<String> clazzes = new LinkedList<String>();
        for (Node node : cu.getChildNodes()) {
            clazzes.addAll(ClazzFinder.getClazzes(node, "", "$"));
        }
        return clazzes;
    }
}

