/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation;

import java.util.HashSet;
import java.util.Set;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import net.kieker.sourceinstrumentation.JavaVersionUtil;
import net.kieker.sourceinstrumentation.instrument.SignatureMatchChecker;
import net.kieker.sourceinstrumentation.instrument.codeblocks.AggregationBlockBuilder;
import net.kieker.sourceinstrumentation.instrument.codeblocks.BlockBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstrumentationConfiguration {
    private static final String JAVA_8_MESSAGE = "Since Java 8 is used, adaptive instrumentation and deactivation is disabled, since both may cause problems with constructor instrumentation. If you like to use this, please consider replacing the return in if (MonitoringController.getInstance().isEnabbled()) { ...; return ; } - calls by an else and check the performance implications.";
    private static final Logger LOG = LogManager.getLogger(InstrumentationConfiguration.class);
    private final AllowedKiekerRecord usedRecord;
    private final boolean aggregate;
    private final int samplingCount;
    private final boolean enableDeactivation;
    private final boolean createDefaultConstructor;
    private final boolean enableAdaptiveMonitoring;
    private final boolean strictMode;
    private final SignatureMatchChecker checker;
    private final boolean extractMethod;

    public InstrumentationConfiguration(AllowedKiekerRecord usedRecord, boolean aggregate, Set<String> includedPatterns, boolean enableAdaptiveMonitoring, boolean enableDecativation, int samplingCount, boolean extractMethod) {
        this.usedRecord = usedRecord;
        this.aggregate = aggregate;
        if (JavaVersionUtil.getSystemJavaVersion() == 8) {
            LOG.info(JAVA_8_MESSAGE);
            this.enableAdaptiveMonitoring = false;
            this.enableDeactivation = false;
            this.extractMethod = false;
        } else {
            this.enableAdaptiveMonitoring = enableAdaptiveMonitoring;
            this.enableDeactivation = enableDecativation;
            this.extractMethod = extractMethod;
        }
        this.createDefaultConstructor = true;
        this.strictMode = false;
        this.samplingCount = samplingCount;
        HashSet<String> excludedPatterns = new HashSet<String>();
        this.checker = new SignatureMatchChecker(includedPatterns, excludedPatterns);
        this.check();
    }

    public InstrumentationConfiguration(AllowedKiekerRecord usedRecord, boolean aggregate, boolean createDefaultConstructor, boolean enableAdaptiveMonitoring, Set<String> includedPatterns, boolean enableDecativation, int samplingCount, boolean extractMethod) {
        this.usedRecord = usedRecord;
        this.aggregate = aggregate;
        this.createDefaultConstructor = createDefaultConstructor;
        if (JavaVersionUtil.getSystemJavaVersion() == 8) {
            LOG.info(JAVA_8_MESSAGE);
            this.enableAdaptiveMonitoring = false;
            this.enableDeactivation = false;
            this.extractMethod = false;
        } else {
            this.enableAdaptiveMonitoring = enableAdaptiveMonitoring;
            this.enableDeactivation = enableDecativation;
            this.extractMethod = extractMethod;
        }
        HashSet<String> excludedPatterns = new HashSet<String>();
        this.samplingCount = samplingCount;
        this.strictMode = false;
        this.checker = new SignatureMatchChecker(includedPatterns, excludedPatterns);
        this.check();
    }

    public InstrumentationConfiguration(AllowedKiekerRecord usedRecord, boolean sample, boolean createDefaultConstructor, boolean enableAdaptiveMonitoring, Set<String> includedPatterns, Set<String> excludedPatterns, boolean enableDecativation, int samplingCount, boolean extractMethod, boolean strictMode) {
        this.usedRecord = usedRecord;
        this.aggregate = sample;
        this.createDefaultConstructor = createDefaultConstructor;
        if (JavaVersionUtil.getSystemJavaVersion() == 8) {
            LOG.info(JAVA_8_MESSAGE);
            this.enableAdaptiveMonitoring = false;
            this.enableDeactivation = false;
            this.extractMethod = false;
        } else {
            this.enableAdaptiveMonitoring = enableAdaptiveMonitoring;
            this.enableDeactivation = enableDecativation;
            this.extractMethod = extractMethod;
        }
        this.samplingCount = samplingCount;
        this.strictMode = strictMode;
        this.checker = new SignatureMatchChecker(includedPatterns, excludedPatterns);
        this.check();
    }

    private void check() {
        if (this.aggregate && this.usedRecord == AllowedKiekerRecord.OPERATIONEXECUTION) {
            throw new RuntimeException("Sampling + OperationExecutionRecord does not make sense, since OperationExecutionRecord contains too complex metadata for sampling");
        }
        if (!this.enableDeactivation && this.extractMethod) {
            throw new RuntimeException("Disabling deactivation and extracting methods does not make sense, since it only slows down the process");
        }
    }

    public AllowedKiekerRecord getUsedRecord() {
        return this.usedRecord;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public int getSamplingCount() {
        return this.samplingCount;
    }

    public boolean isCreateDefaultConstructor() {
        return this.createDefaultConstructor;
    }

    public boolean isEnableAdaptiveMonitoring() {
        return this.enableAdaptiveMonitoring;
    }

    public boolean isEnableDeactivation() {
        return this.enableDeactivation;
    }

    public boolean isExtractMethod() {
        return this.extractMethod;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public BlockBuilder getBlockBuilder() {
        BlockBuilder blockBuilder = this.isAggregate() ? new AggregationBlockBuilder(this.getUsedRecord(), this.getSamplingCount()) : new BlockBuilder(this.getUsedRecord(), this.isEnableDeactivation(), this.isEnableAdaptiveMonitoring());
        return blockBuilder;
    }

    public SignatureMatchChecker getChecker() {
        return this.checker;
    }
}

