/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import java.util.Optional;

public class ReachabilityDecider {
    public static boolean isAfterUnreachable(BlockStmt originalBlock) {
        boolean afterUnreachable = false;
        Optional optionalLast = originalBlock.getStatements().getLast();
        if (optionalLast.isPresent()) {
            Statement last = (Statement)optionalLast.get();
            afterUnreachable |= ReachabilityDecider.isAfterLastUnreachable(last);
        }
        return afterUnreachable;
    }

    private static boolean isAfterLastUnreachable(Statement last) {
        boolean afterUnreachable = false;
        if (last instanceof ThrowStmt) {
            afterUnreachable = true;
        } else if (last instanceof WhileStmt) {
            WhileStmt stmt = (WhileStmt)last;
            if (stmt.getCondition().toString().equals("true")) {
                afterUnreachable = true;
            }
        } else if (last instanceof DoStmt) {
            DoStmt stmt = (DoStmt)last;
            if (stmt.getCondition().toString().equals("true")) {
                afterUnreachable = true;
            }
        } else if (last instanceof TryStmt) {
            TryStmt stmt = (TryStmt)last;
            afterUnreachable = ReachabilityDecider.isAfterUnreachable(stmt.getTryBlock());
            if (afterUnreachable) {
                for (CatchClause catchClause : stmt.getCatchClauses()) {
                    afterUnreachable &= ReachabilityDecider.isAfterUnreachable(catchClause.getBody());
                }
            }
        } else if (last instanceof ReturnStmt) {
            afterUnreachable = true;
        } else {
            SwitchStmt switchStmt;
            Optional optionalLastSwitch;
            if (last instanceof BlockStmt) {
                return ReachabilityDecider.isAfterUnreachable((BlockStmt)last);
            }
            if (last instanceof SynchronizedStmt) {
                return ReachabilityDecider.isAfterUnreachable(((SynchronizedStmt)last).getBody());
            }
            if (last instanceof ForStmt) {
                ForStmt stmt = (ForStmt)last;
                Optional end = stmt.getCompare();
                if (!end.isPresent()) {
                    return true;
                }
            } else if (last instanceof IfStmt) {
                Statement elseStatement;
                boolean elseAfterEndIsUnreachable;
                IfStmt ifStatement = (IfStmt)last;
                if (ifStatement.getElseStmt().isPresent() && (elseAfterEndIsUnreachable = ReachabilityDecider.isAfterLastUnreachable(elseStatement = (Statement)ifStatement.getElseStmt().get()))) {
                    boolean thenAfterEndIsUnreachable = ReachabilityDecider.isAfterLastUnreachable(ifStatement.getThenStmt());
                    if (elseAfterEndIsUnreachable && thenAfterEndIsUnreachable) {
                        return true;
                    }
                }
            } else if (last instanceof SwitchStmt && (optionalLastSwitch = (switchStmt = (SwitchStmt)last).getEntries().getLast()).isPresent()) {
                SwitchEntry lastSwitch = (SwitchEntry)optionalLastSwitch.get();
                if (lastSwitch.toString().startsWith("default:")) {
                    Optional potentialLastStatement = lastSwitch.getStatements().getLast();
                    if (potentialLastStatement.isPresent()) {
                        return ReachabilityDecider.isAfterLastUnreachable((Statement)potentialLastStatement.get());
                    }
                    return false;
                }
                return false;
            }
        }
        return afterUnreachable;
    }
}

