/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument.codeblocks;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import net.kieker.sourceinstrumentation.InstrumentationCodeBlocks;
import net.kieker.sourceinstrumentation.instrument.SamplingParameters;
import net.kieker.sourceinstrumentation.instrument.codeblocks.BlockBuilder;
import net.kieker.sourceinstrumentation.instrument.codeblocks.CodeBlockTransformer;

public class AggregationBlockBuilder
extends BlockBuilder {
    private final int count;

    public AggregationBlockBuilder(AllowedKiekerRecord recordType, int count) {
        super(recordType, false, false);
        this.count = count;
    }

    @Override
    public BlockStmt buildStatement(TypeDeclaration<?> type, BlockStmt originalBlock, boolean addReturn, SamplingParameters parameters, CodeBlockTransformer transformer) {
        if (this.recordType.equals((Object)AllowedKiekerRecord.OPERATIONEXECUTION)) {
            throw new RuntimeException("Not implemented yet (Aggregation + OperationExecutionRecord does not make sense, since OperationExecutionRecord contains too complex metadata for sampling)");
        }
        if (this.recordType.equals((Object)AllowedKiekerRecord.DURATION)) {
            if (!this.useStaticVariables) {
                return super.buildStatement(type, originalBlock, addReturn, parameters, transformer);
            }
            return this.buildSelectiveSamplingStatement(type, originalBlock, addReturn, parameters);
        }
        throw new RuntimeException();
    }

    @Override
    public BlockStmt buildEmptyConstructor(TypeDeclaration<?> type, SamplingParameters parameters, CodeBlockTransformer transformer) {
        if (this.recordType.equals((Object)AllowedKiekerRecord.OPERATIONEXECUTION)) {
            throw new RuntimeException("Not implemented yet (Aggregation + OperationExecutionRecord does not make sense, since OperationExecutionRecord contains too complex metadata for sampling)");
        }
        if (this.recordType.equals((Object)AllowedKiekerRecord.DURATION)) {
            return this.buildConstructorStatement(type, parameters);
        }
        throw new RuntimeException();
    }

    public BlockStmt buildSelectiveSamplingStatement(TypeDeclaration<?> type, BlockStmt originalBlock, boolean addReturn, SamplingParameters parameters) {
        BlockStmt replacedStatement = new BlockStmt();
        String beforeText = this.getBeforeText(type);
        replacedStatement.addAndGetStatement(beforeText);
        BlockStmt finallyBlock = new BlockStmt();
        finallyBlock.addAndGetStatement(parameters.getFinalBlock(type, parameters.getSignature(), this.count));
        TryStmt stmt = new TryStmt(originalBlock, new NodeList(), finallyBlock);
        replacedStatement.addAndGetStatement((Statement)stmt);
        return replacedStatement;
    }

    private String getBeforeText(TypeDeclaration<?> type) {
        ClassOrInterfaceDeclaration declaration;
        String beforeText = type instanceof ClassOrInterfaceDeclaration ? ((declaration = (ClassOrInterfaceDeclaration)type).isInterface() ? CodeBlockTransformer.replaceStaticVariablesByClassStaticVariables(InstrumentationCodeBlocks.AGGREGATION.getBefore()) : InstrumentationCodeBlocks.AGGREGATION.getBefore()) : CodeBlockTransformer.replaceStaticVariablesByClassStaticVariables(InstrumentationCodeBlocks.AGGREGATION.getBefore());
        return beforeText;
    }

    public BlockStmt buildConstructorStatement(TypeDeclaration<?> type, SamplingParameters parameters) {
        BlockStmt replacedStatement = new BlockStmt();
        String beforeText = this.getBeforeText(type);
        replacedStatement.addAndGetStatement(beforeText);
        replacedStatement.addAndGetStatement(parameters.getFinalBlock(type, parameters.getSignature(), this.count));
        return replacedStatement;
    }
}

