/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument.codeblocks;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import net.kieker.sourceinstrumentation.InstrumentationCodeBlocks;
import net.kieker.sourceinstrumentation.instrument.SamplingParameters;
import net.kieker.sourceinstrumentation.instrument.codeblocks.CodeBlockTransformer;
import net.kieker.sourceinstrumentation.instrument.codeblocks.HeaderBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockBuilder {
    private static final Logger LOG = LogManager.getLogger(BlockBuilder.class);
    protected final AllowedKiekerRecord recordType;
    private final boolean enableDeactivation;
    private final boolean enableAdaptiveMonitoring;
    protected boolean useStaticVariables = true;

    public BlockBuilder(AllowedKiekerRecord recordType, boolean enableDeactivation, boolean enableAdaptiveMonitoring) {
        this.recordType = recordType;
        this.enableDeactivation = enableDeactivation;
        this.enableAdaptiveMonitoring = enableAdaptiveMonitoring;
    }

    public BlockStmt buildConstructorStatement(BlockStmt originalBlock, boolean mayNeedReturn, SamplingParameters parameters, TypeDeclaration<?> type, CodeBlockTransformer transformer) {
        if (type.isEnumDeclaration()) {
            this.useStaticVariables = false;
        }
        LOG.trace("Statements: " + originalBlock.getStatements().size() + " " + parameters.getSignature());
        BlockStmt replacedStatement = new BlockStmt();
        ExplicitConstructorInvocationStmt constructorStatement = this.findConstructorInvocation(originalBlock);
        if (constructorStatement != null) {
            replacedStatement.addAndGetStatement((Statement)constructorStatement);
            originalBlock.getStatements().remove((Node)constructorStatement);
        }
        BlockStmt regularChangedStatement = this.buildStatement(type, originalBlock, mayNeedReturn, parameters, transformer);
        for (Statement st : regularChangedStatement.getStatements()) {
            replacedStatement.addAndGetStatement(st);
        }
        this.useStaticVariables = true;
        return replacedStatement;
    }

    private ExplicitConstructorInvocationStmt findConstructorInvocation(BlockStmt originalBlock) {
        ExplicitConstructorInvocationStmt constructorStatement = null;
        for (Statement st : originalBlock.getStatements()) {
            if (!(st instanceof ExplicitConstructorInvocationStmt)) continue;
            constructorStatement = (ExplicitConstructorInvocationStmt)st;
        }
        return constructorStatement;
    }

    public BlockStmt buildStatement(TypeDeclaration<?> type, BlockStmt originalBlock, boolean mayNeedReturn, SamplingParameters parameters, CodeBlockTransformer transformer) {
        if (this.recordType.equals((Object)AllowedKiekerRecord.OPERATIONEXECUTION)) {
            return this.buildOperationExecutionStatement(originalBlock, parameters.getSignature(), mayNeedReturn, transformer);
        }
        if (this.recordType.equals((Object)AllowedKiekerRecord.DURATION)) {
            return this.buildDurationStatement(originalBlock, parameters.getSignature(), mayNeedReturn, transformer);
        }
        throw new RuntimeException();
    }

    public BlockStmt buildDurationStatement(BlockStmt originalBlock, String signature, boolean mayNeedReturn, CodeBlockTransformer transformer) {
        BlockStmt replacedStatement = new BlockStmt();
        new HeaderBuilder(this.useStaticVariables, this.enableDeactivation, this.enableAdaptiveMonitoring, transformer).buildHeader(originalBlock, signature, mayNeedReturn, replacedStatement);
        String before = InstrumentationCodeBlocks.DURATION_RECORD.getBefore();
        if (!this.useStaticVariables) {
            before = CodeBlockTransformer.replaceStaticVariables(before);
        }
        replacedStatement.addAndGetStatement(before);
        BlockStmt finallyBlock = new BlockStmt();
        String finallyText = InstrumentationCodeBlocks.DURATION_RECORD.getAfter();
        if (!this.useStaticVariables) {
            finallyText = CodeBlockTransformer.replaceStaticVariables(finallyText);
        }
        finallyBlock.addAndGetStatement(finallyText);
        TryStmt stmt = new TryStmt(originalBlock, new NodeList(), finallyBlock);
        replacedStatement.addAndGetStatement((Statement)stmt);
        return replacedStatement;
    }

    public BlockStmt buildOperationExecutionStatement(BlockStmt originalBlock, String signature, boolean mayNeedReturn, CodeBlockTransformer transformer) {
        BlockStmt replacedStatement = new BlockStmt();
        new HeaderBuilder(this.useStaticVariables, this.enableDeactivation, this.enableAdaptiveMonitoring, transformer).buildHeader(originalBlock, signature, mayNeedReturn, replacedStatement);
        String before = transformer.getTransformedBlock(InstrumentationCodeBlocks.OPERATIONEXECUTION.getBefore(), this.useStaticVariables);
        replacedStatement.addAndGetStatement(before);
        BlockStmt finallyBlock = new BlockStmt();
        String after = transformer.getTransformedBlock(InstrumentationCodeBlocks.OPERATIONEXECUTION.getAfter(), this.useStaticVariables);
        finallyBlock.addAndGetStatement(after);
        TryStmt stmt = new TryStmt(originalBlock, new NodeList(), finallyBlock);
        replacedStatement.addAndGetStatement((Statement)stmt);
        return replacedStatement;
    }

    public BlockStmt buildEmptyConstructor(TypeDeclaration<?> type, SamplingParameters parameters, CodeBlockTransformer transformer) {
        BlockStmt replacedStatement = new BlockStmt();
        if (this.recordType.equals((Object)AllowedKiekerRecord.OPERATIONEXECUTION)) {
            if (type.isEnumDeclaration()) {
                this.useStaticVariables = false;
            }
            this.buildEmptyConstructor(parameters.getSignature(), replacedStatement, InstrumentationCodeBlocks.OPERATIONEXECUTION.getBefore(), InstrumentationCodeBlocks.OPERATIONEXECUTION.getAfter(), transformer);
            this.useStaticVariables = true;
        } else if (this.recordType.equals((Object)AllowedKiekerRecord.DURATION)) {
            if (type.isEnumDeclaration()) {
                this.useStaticVariables = false;
            }
            this.buildEmptyConstructor(parameters.getSignature(), replacedStatement, InstrumentationCodeBlocks.DURATION_RECORD.getBefore(), InstrumentationCodeBlocks.DURATION_RECORD.getAfter(), transformer);
            this.useStaticVariables = false;
        } else {
            throw new RuntimeException();
        }
        return replacedStatement;
    }

    private void buildEmptyConstructor(String signature, BlockStmt replacedStatement, String before, String after, CodeBlockTransformer transformer) {
        new HeaderBuilder(this.useStaticVariables, this.enableDeactivation, this.enableAdaptiveMonitoring, transformer).buildHeader(new BlockStmt(), signature, false, replacedStatement);
        replacedStatement.addAndGetStatement(transformer.getTransformedBlock(before, this.useStaticVariables));
        replacedStatement.addAndGetStatement(transformer.getTransformedBlock(after, this.useStaticVariables));
    }
}

