/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument.codeblocks;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import net.kieker.sourceinstrumentation.instrument.ReachabilityDecider;
import net.kieker.sourceinstrumentation.instrument.codeblocks.CodeBlockTransformer;

public class HeaderBuilder {
    private final boolean useStaticVariables;
    private final boolean enableDeactivation;
    private final boolean enableAdaptiveMonitoring;
    private final CodeBlockTransformer transformer;

    public HeaderBuilder(boolean useStaticVariables, boolean enableDeactivation, boolean enableAdaptiveMonitoring, CodeBlockTransformer transformer) {
        this.useStaticVariables = useStaticVariables;
        this.enableDeactivation = enableDeactivation;
        this.enableAdaptiveMonitoring = enableAdaptiveMonitoring;
        this.transformer = transformer;
    }

    public void buildHeader(BlockStmt originalBlock, String signature, boolean needsReturn, BlockStmt replacedStatement) {
        boolean afterUnreachable = ReachabilityDecider.isAfterUnreachable(originalBlock);
        boolean addReturn = needsReturn && !afterUnreachable;
        BlockStmt changed = addReturn ? (BlockStmt)originalBlock.addStatement("return;") : originalBlock;
        String controllerName = this.transformer.getControllerName(this.useStaticVariables);
        if (this.enableDeactivation) {
            this.addDeactivationStatement(replacedStatement, changed, controllerName);
        }
        replacedStatement.addAndGetStatement("final String _kieker_sourceInstrumentation_signature = \"" + signature + "\";");
        if (this.enableAdaptiveMonitoring) {
            this.addAdaptiveMonitoringStatement(replacedStatement, changed, controllerName);
        }
    }

    private void addAdaptiveMonitoringStatement(BlockStmt replacedStatement, BlockStmt changed, String controllerName) {
        NameExpr name = new NameExpr("_kieker_sourceInstrumentation_signature");
        MethodCallExpr expr = new MethodCallExpr("!" + controllerName + ".isProbeActivated", new Expression[]{name});
        IfStmt ifS = new IfStmt((Expression)expr, (Statement)changed, null);
        replacedStatement.addStatement((Statement)ifS);
    }

    private void addDeactivationStatement(BlockStmt replacedStatement, BlockStmt changed, String controllerName) {
        MethodCallExpr expr = new MethodCallExpr("!" + controllerName + ".isMonitoringEnabled", new Expression[0]);
        IfStmt ifS = new IfStmt((Expression)expr, (Statement)changed, null);
        replacedStatement.addStatement((Statement)ifS);
    }
}

