/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import net.kieker.sourceinstrumentation.InstrumentationConfiguration;
import net.kieker.sourceinstrumentation.instrument.FileInstrumenter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstrumentKiekerSource {
    private static final Logger LOG = LogManager.getLogger(InstrumentKiekerSource.class);
    private InstrumentationConfiguration configuration;

    public InstrumentKiekerSource(AllowedKiekerRecord usedRecord) {
        this.configuration = new InstrumentationConfiguration(usedRecord, false, true, true, new HashSet<String>(), false, 1000, false);
        this.configuration.getIncludedPatterns().add("*");
    }

    public InstrumentKiekerSource(InstrumentationConfiguration configuration) {
        this.configuration = configuration;
    }

    public void instrumentProject(File projectFolder) throws IOException {
        for (File javaFile : FileUtils.listFiles((File)projectFolder, (IOFileFilter)new WildcardFileFilter("*.java"), (IOFileFilter)TrueFileFilter.INSTANCE)) {
            LOG.trace("Instrumenting: {}", (Object)javaFile);
            this.instrument(javaFile);
        }
    }

    public void instrument(File file) throws IOException {
        FileInstrumenter instrumenter = new FileInstrumenter(file, this.configuration);
        instrumenter.instrument();
    }
}

