/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

import java.util.Set;
import java.util.regex.Pattern;
import kieker.monitoring.core.signaturePattern.InvalidPatternException;
import kieker.monitoring.core.signaturePattern.PatternParser;
import net.kieker.sourceinstrumentation.instrument.FileInstrumenter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureMatchChecker {
    private static final Logger LOG = LogManager.getLogger(FileInstrumenter.class);
    private Set<String> includes;
    private Set<String> excludes;

    public SignatureMatchChecker(Set<String> includes, Set<String> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean testSignatureMatch(String signature) {
        boolean oneMatches = false;
        oneMatches = this.includes == null ? true : this.oneIncludeMatches(signature, oneMatches);
        if (this.excludes != null) {
            oneMatches = this.oneExcludeMatches(signature, oneMatches);
        }
        return oneMatches;
    }

    private boolean oneExcludeMatches(String signature, boolean oneMatches) {
        for (String pattern : this.excludes) {
            pattern = this.fixConstructorPattern(pattern);
            try {
                Pattern patternP = PatternParser.parseToPattern((String)pattern);
                if (!patternP.matcher(signature).matches()) continue;
                oneMatches = false;
                break;
            }
            catch (InvalidPatternException e) {
                LOG.error("Wrong pattern: {}", (Object)pattern);
                throw new RuntimeException(e);
            }
        }
        return oneMatches;
    }

    private boolean oneIncludeMatches(String signature, boolean oneMatches) {
        for (String pattern : this.includes) {
            pattern = this.fixConstructorPattern(pattern);
            try {
                Pattern patternP = PatternParser.parseToPattern((String)pattern);
                if (!patternP.matcher(signature).matches()) continue;
                oneMatches = true;
                break;
            }
            catch (InvalidPatternException e) {
                LOG.error("Wrong pattern: {}", (Object)pattern);
                throw new RuntimeException(e);
            }
        }
        return oneMatches;
    }

    private String fixConstructorPattern(String pattern) {
        if (pattern.contains("<init>")) {
            String returnType;
            String[] tokens = pattern.substring(0, pattern.indexOf(40)).trim().split("\\s+");
            int returnTypeIndex = 0;
            String modifier = "";
            if (tokens[0].equals("private") || tokens[0].equals("public") || tokens[0].equals("protected")) {
                ++returnTypeIndex;
                modifier = tokens[0];
            }
            if ((returnType = tokens[returnTypeIndex]).equals("new")) {
                String patternChanged = modifier + " *" + pattern.substring(pattern.indexOf("new") + 3);
                LOG.trace("Changing pattern {} to {}, since Kieker 1.14 does not allow pattern with new", (Object)pattern, (Object)patternChanged);
                pattern = patternChanged;
            }
        }
        return pattern;
    }
}

