/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.kieker.sourceinstrumentation.parseUtils.ClazzFinder;

public class SignatureReader {
    private static final List<String> javaLangClasses = new LinkedList<String>(Arrays.asList("AbstractMethodError", "AbstractStringBuilder", "Appendable", "ApplicationShutdownHooks", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "AssertionError", "AssertionStatusDirectives", "AutoCloseable", "Boolean", "BootstrapMethodError", "Byte", "CharSequence", "Character", "CharacterData", "CharacterName", "Class", "ClassCastException", "ClassCircularityError", "ClassFormatError", "ClassLoader", "ClassNotFoundException", "ClassValue", "CloneNotSupportedException", "Cloneable", "Comparable", "Compiler", "ConditionalSpecialCasing", "Deprecated", "Double", "Enum", "EnumConstantNotPresentException", "Error", "Exception", "ExceptionInInitializerError", "Float", "FunctionalInterface", "IllegalAccessError", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IncompatibleClassChangeError", "IndexOutOfBoundsException", "InheritableThreadLocal", "InstantiationError", "InstantiationException", "Integer", "InternalError", "InterruptedException", "Iterable", "LinkageError", "Long", "Math", "NegativeArraySizeException", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchFieldException", "NoSuchMethodError", "NoSuchMethodException", "NullPointerException", "Number", "NumberFormatException", "Object", "OutOfMemoryError", "Override", "Package", "Process", "ProcessBuilder", "Readable", "ReflectiveOperationException", "Runnable", "Runtime", "RuntimeException", "RuntimePermission", "SafeVarargs", "SecurityException", "SecurityManager", "Short", "Shutdown", "StackOverflowError", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "StringCoding", "StringIndexOutOfBoundsException", "SuppressWarnings", "System", "Thread", "ThreadDeath", "ThreadGroup", "ThreadLocal", "Throwable", "TypeNotPresentException", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "UnsupportedOperationException", "VerifyError", "VirtualMachineError", "Void"));
    private final CompilationUnit unit;
    private final String name;
    private final List<String> localClazzes;

    public SignatureReader(CompilationUnit unit, String name) {
        this.unit = unit;
        this.name = name;
        this.localClazzes = ClazzFinder.getClazzes(unit);
    }

    public String getDefaultConstructor(TypeDeclaration<?> clazz) {
        String visibility = this.getVisibility(clazz);
        String signature = visibility + "new " + this.name + ".<init>(";
        signature = this.addInnerClassConstructorParameter(clazz, signature, (NodeList<Parameter>)new NodeList());
        signature = signature + ")";
        return signature;
    }

    private String getVisibility(TypeDeclaration<?> clazz) {
        Modifier clazzVisiblity = null;
        for (Modifier clazzModifier : clazz.getModifiers()) {
            if (!clazzModifier.equals((Object)Modifier.privateModifier()) && !clazzModifier.equals((Object)Modifier.protectedModifier()) && !clazzModifier.equals((Object)Modifier.publicModifier())) continue;
            clazzVisiblity = clazzModifier;
        }
        String visibility = clazzVisiblity != null ? clazzVisiblity.toString() : "";
        return visibility;
    }

    public String getSignature(MethodDeclaration method) {
        String modifiers = this.getModifierString((NodeList<Modifier>)method.getModifiers());
        String returnTypFQN = this.getTypeFQN(method.getType());
        String returnType = returnTypFQN + " ";
        String signature = modifiers + returnType + this.name + "(";
        signature = signature + this.getParameterString((NodeList<Parameter>)method.getParameters());
        signature = signature + ")";
        return signature;
    }

    public String getSignature(TypeDeclaration<?> clazz, ConstructorDeclaration method) {
        String modifiers = this.getModifierString((NodeList<Modifier>)method.getModifiers());
        String signature = modifiers + "new " + this.name + ".<init>(";
        signature = this.addInnerClassConstructorParameter(clazz, signature, (NodeList<Parameter>)method.getParameters());
        signature = signature + ")";
        return signature;
    }

    private String addInnerClassConstructorParameter(TypeDeclaration<?> clazz, String signature, NodeList<Parameter> parameters) {
        if (this.name.contains("$") && !clazz.isStatic()) {
            String firstConstructorPart = this.name.substring(0, this.name.lastIndexOf(36));
            signature = signature + firstConstructorPart;
            if (parameters.size() > 0) {
                signature = signature + ",";
            }
        }
        signature = signature + this.getParameterString(parameters);
        return signature;
    }

    private String getParameterString(NodeList<Parameter> methodParameters) {
        String parameterString = "";
        for (Parameter parameter : methodParameters) {
            String fqn = this.getTypeFQN(parameter.getType());
            parameterString = parameterString + fqn + ",";
        }
        if (parameterString.length() > 0) {
            parameterString = parameterString.substring(0, parameterString.length() - 1);
        }
        return parameterString;
    }

    private String getTypeFQN(Type type) {
        String fqn;
        String typeName = type.asString();
        if (typeName.contains("<")) {
            String beforeGenerics = typeName.substring(0, typeName.indexOf(60));
            String afterGenerics = typeName.substring(typeName.lastIndexOf(62) + 1, typeName.length());
            typeName = beforeGenerics + afterGenerics;
        }
        if (typeName.equals("void")) {
            return typeName;
        }
        if (type.isPrimitiveType()) {
            fqn = typeName;
        } else if (type.isArrayType()) {
            String typeNameWithoutArray;
            ImportDeclaration currentImport;
            ArrayType arrayType = (ArrayType)type;
            Type componentType = arrayType.getComponentType();
            String arrayString = arrayType.asString().substring(arrayType.asString().indexOf(91));
            fqn = componentType.isPrimitiveType() ? typeName : ((currentImport = this.findImport(typeNameWithoutArray = typeName.substring(0, typeName.indexOf(91)))) != null ? currentImport.getNameAsString() + arrayString : this.getReferenceInnerClazz(typeNameWithoutArray));
            if (!fqn.endsWith(arrayString)) {
                fqn = fqn + arrayString;
            }
        } else {
            ImportDeclaration currentImport = this.findImport(typeName);
            fqn = currentImport != null ? currentImport.getNameAsString() : this.getReferenceInnerClazz(typeName);
        }
        return fqn;
    }

    private String getReferenceInnerClazz(String typeNameWithoutArray) {
        String packageName;
        String matchingInnerClass = null;
        for (String innerClass : this.localClazzes) {
            if (!innerClass.endsWith(typeNameWithoutArray)) continue;
            matchingInnerClass = innerClass;
        }
        Optional packageDeclaration = this.unit.getPackageDeclaration();
        String string = packageName = packageDeclaration.isPresent() ? ((PackageDeclaration)packageDeclaration.get()).getNameAsString() + "." : "";
        String fqn = matchingInnerClass != null ? packageName + matchingInnerClass : (javaLangClasses.contains(typeNameWithoutArray) ? "java.lang." + typeNameWithoutArray : packageName + typeNameWithoutArray);
        return fqn;
    }

    private ImportDeclaration findImport(String typeName) {
        ImportDeclaration currentImport = null;
        for (ImportDeclaration importDeclaration : this.unit.getImports()) {
            String importFqn = importDeclaration.getNameAsString();
            if (!importFqn.endsWith("." + typeName)) continue;
            currentImport = importDeclaration;
            break;
        }
        return currentImport;
    }

    private String getModifierString(NodeList<Modifier> listOfModifiers) {
        String modifiers = "";
        for (Modifier modifier : listOfModifiers) {
            modifiers = modifiers + modifier;
        }
        return modifiers;
    }
}

