/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument.codeblocks;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import net.kieker.sourceinstrumentation.InstrumentationCodeBlocks;
import net.kieker.sourceinstrumentation.instrument.SamplingParameters;
import net.kieker.sourceinstrumentation.instrument.codeblocks.BlockBuilder;
import net.kieker.sourceinstrumentation.instrument.codeblocks.CodeBlockTransformer;

public class AggregationBlockBuilder
extends BlockBuilder {
    private final int count;

    public AggregationBlockBuilder(AllowedKiekerRecord recordType, int count) {
        super(recordType, false, false);
        this.count = count;
    }

    @Override
    public BlockStmt buildStatement(BlockStmt originalBlock, boolean addReturn, SamplingParameters parameters, CodeBlockTransformer transformer) {
        if (this.recordType.equals((Object)AllowedKiekerRecord.OPERATIONEXECUTION)) {
            throw new RuntimeException("Not implemented yet (Aggregation + OperationExecutionRecord does not make sense, since OperationExecutionRecord contains too complex metadata for sampling)");
        }
        if (this.recordType.equals((Object)AllowedKiekerRecord.DURATION)) {
            if (!this.useStaticVariables) {
                return super.buildStatement(originalBlock, addReturn, parameters, transformer);
            }
            return this.buildSelectiveSamplingStatement(originalBlock, addReturn, parameters);
        }
        throw new RuntimeException();
    }

    @Override
    public BlockStmt buildEmptyConstructor(TypeDeclaration<?> type, SamplingParameters parameters, CodeBlockTransformer transformer) {
        if (this.recordType.equals((Object)AllowedKiekerRecord.OPERATIONEXECUTION)) {
            throw new RuntimeException("Not implemented yet (Aggregation + OperationExecutionRecord does not make sense, since OperationExecutionRecord contains too complex metadata for sampling)");
        }
        if (this.recordType.equals((Object)AllowedKiekerRecord.DURATION)) {
            return this.buildConstructorStatement(parameters);
        }
        throw new RuntimeException();
    }

    public BlockStmt buildSelectiveSamplingStatement(BlockStmt originalBlock, boolean addReturn, SamplingParameters parameters) {
        BlockStmt replacedStatement = new BlockStmt();
        replacedStatement.addAndGetStatement(InstrumentationCodeBlocks.AGGREGATION.getBefore());
        BlockStmt finallyBlock = new BlockStmt();
        finallyBlock.addAndGetStatement(parameters.getFinalBlock(parameters.getSignature(), this.count));
        TryStmt stmt = new TryStmt(originalBlock, new NodeList(), finallyBlock);
        replacedStatement.addAndGetStatement((Statement)stmt);
        return replacedStatement;
    }

    public BlockStmt buildConstructorStatement(SamplingParameters parameters) {
        BlockStmt replacedStatement = new BlockStmt();
        replacedStatement.addAndGetStatement(InstrumentationCodeBlocks.AGGREGATION.getBefore());
        replacedStatement.addAndGetStatement(parameters.getFinalBlock(parameters.getSignature(), this.count));
        return replacedStatement;
    }
}

