/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import net.kieker.sourceinstrumentation.InstrumentationConfiguration;
import net.kieker.sourceinstrumentation.instrument.KiekerFieldAdder;
import net.kieker.sourceinstrumentation.instrument.SamplingParameters;
import net.kieker.sourceinstrumentation.instrument.SignatureMatchChecker;
import net.kieker.sourceinstrumentation.instrument.SignatureReader;
import net.kieker.sourceinstrumentation.instrument.codeblocks.BlockBuilder;
import net.kieker.sourceinstrumentation.instrument.codeblocks.CodeBlockTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TypeInstrumenter {
    private static final Logger LOG = LogManager.getLogger(TypeInstrumenter.class);
    private final InstrumentationConfiguration configuration;
    private final BlockBuilder blockBuilder;
    private int counterIndex = 0;
    private final List<String> countersToAdd = new LinkedList<String>();
    private final List<String> sumsToAdd = new LinkedList<String>();
    private final SignatureMatchChecker checker;
    private final CompilationUnit unit;
    private final TypeDeclaration<?> topLevelType;
    private final CodeBlockTransformer transformer;
    private boolean oneHasChanged = false;

    public TypeInstrumenter(InstrumentationConfiguration configuration, CompilationUnit unit, TypeDeclaration<?> topLevelType) {
        this.configuration = configuration;
        this.blockBuilder = configuration.getBlockBuilder();
        this.checker = configuration.getChecker();
        this.unit = unit;
        this.topLevelType = topLevelType;
        this.transformer = new CodeBlockTransformer(topLevelType);
    }

    public boolean handleTypeDeclaration(TypeDeclaration<?> type, String packageName) throws IOException {
        String name;
        boolean fileContainsChange;
        if (type != null && (fileContainsChange = this.handleChildren(type, name = packageName + type.getNameAsString()))) {
            for (String counterName : this.countersToAdd) {
                type.addField("int", counterName, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC});
            }
            for (String counterName : this.sumsToAdd) {
                type.addField("long", counterName, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC});
            }
            if (type == this.topLevelType) {
                new KiekerFieldAdder(this.configuration).addKiekerFields(type);
            }
            return true;
        }
        return false;
    }

    private boolean handleChildren(TypeDeclaration<?> clazz, String name) {
        LinkedList<MethodDeclaration> methodsToAdd = new LinkedList<MethodDeclaration>();
        boolean constructorFound = false;
        ListIterator childIterator = clazz.getChildNodes().listIterator();
        while (childIterator.hasNext()) {
            Node child = (Node)childIterator.next();
            if (child instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)child;
                if (clazz instanceof ClassOrInterfaceDeclaration) {
                    ClassOrInterfaceDeclaration declaringEntity = (ClassOrInterfaceDeclaration)clazz;
                    if (declaringEntity.isInterface() && !method.getBody().isPresent()) continue;
                    if (this.configuration.isExtractMethod()) {
                        this.extractMethod(methodsToAdd, method);
                    }
                    this.instrumentMethod(name, method);
                    continue;
                }
                this.instrumentMethod(name, method);
                continue;
            }
            if (child instanceof ConstructorDeclaration) {
                this.instrumentConstructor(clazz, name, child);
                constructorFound = true;
                continue;
            }
            if (!(child instanceof ClassOrInterfaceDeclaration)) continue;
            ClassOrInterfaceDeclaration innerClazz = (ClassOrInterfaceDeclaration)child;
            String innerName = innerClazz.getNameAsString();
            this.handleChildren((TypeDeclaration<?>)innerClazz, name + "$" + innerName);
        }
        this.addExtractedWorkloadMethods(clazz, methodsToAdd);
        this.handleDefaultConstructor(clazz, name, constructorFound);
        return this.oneHasChanged;
    }

    private void extractMethod(List<MethodDeclaration> methodsToAdd, MethodDeclaration method) {
        String generatedName = this.generateWorkloadMethod(methodsToAdd, method);
        BlockStmt newBody = new BlockStmt();
        NodeList parameterCallList = new NodeList();
        method.getParameters().stream().forEach(parameter -> parameterCallList.add((Node)parameter.getNameAsExpression()));
        ExpressionStmt exprStatment = method.getType().toString().equals("void") ? new ExpressionStmt((Expression)new MethodCallExpr(generatedName, (Expression[])parameterCallList.toArray((Object[])new Expression[0]))) : new ExpressionStmt((Expression)new MethodCallExpr("return " + generatedName, (Expression[])parameterCallList.toArray((Object[])new Expression[0])));
        newBody.addStatement((Statement)exprStatment);
        method.setBody(newBody);
    }

    private String generateWorkloadMethod(List<MethodDeclaration> methodsToAdd, MethodDeclaration method) {
        String generatedName = "_kieker_sourceInstrumentation_" + method.getNameAsString();
        MethodDeclaration extracted = new MethodDeclaration();
        extracted.setName(generatedName);
        extracted.setType(method.getType());
        extracted.setBody((BlockStmt)method.getBody().get());
        extracted.getParameters().addAll(method.getParameters());
        if (method.isStatic()) {
            extracted.setStatic(true);
        }
        methodsToAdd.add(extracted);
        return generatedName;
    }

    private void addExtractedWorkloadMethods(TypeDeclaration<?> clazz, List<MethodDeclaration> methodsToAdd) {
        for (MethodDeclaration methodToAdd : methodsToAdd) {
            MethodDeclaration addedMethod = clazz.addMethod(methodToAdd.getNameAsString(), new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
            if (methodToAdd.isStatic()) {
                addedMethod.setStatic(true);
            }
            addedMethod.getParameters().addAll(methodToAdd.getParameters());
            addedMethod.setBody((BlockStmt)methodToAdd.getBody().get());
            addedMethod.setType(methodToAdd.getType());
        }
    }

    private void handleDefaultConstructor(TypeDeclaration<?> clazz, String name, boolean constructorFound) {
        if (!constructorFound && this.configuration.isCreateDefaultConstructor()) {
            ClassOrInterfaceDeclaration clazzDecl;
            if (clazz instanceof EnumDeclaration) {
                this.createDefaultConstructor(clazz, name, Modifier.Keyword.PRIVATE);
            } else if (clazz instanceof ClassOrInterfaceDeclaration && !(clazzDecl = (ClassOrInterfaceDeclaration)clazz).isInterface()) {
                this.createDefaultConstructor(clazz, name, Modifier.Keyword.PUBLIC);
            }
        }
    }

    private void createDefaultConstructor(TypeDeclaration<?> type, String name, Modifier.Keyword visibility) {
        SignatureReader reader = new SignatureReader(this.unit, name);
        String signature = reader.getDefaultConstructor(type);
        if (this.checker.testSignatureMatch(signature)) {
            this.oneHasChanged = true;
            SamplingParameters parameters = this.createParameters(signature);
            BlockStmt constructorBlock = this.blockBuilder.buildEmptyConstructor(type, parameters, this.transformer);
            ConstructorDeclaration constructor = type.addConstructor(new Modifier.Keyword[]{visibility});
            constructor.setBody(constructorBlock);
        }
    }

    private void instrumentConstructor(TypeDeclaration<?> type, String name, Node child) {
        ConstructorDeclaration constructor = (ConstructorDeclaration)child;
        BlockStmt originalBlock = constructor.getBody();
        SignatureReader reader = new SignatureReader(this.unit, name);
        String signature = reader.getSignature(type, constructor);
        boolean oneMatches = this.checker.testSignatureMatch(signature);
        if (oneMatches) {
            SamplingParameters parameters = this.createParameters(signature);
            boolean configurationRequiresReturn = this.configuration.isEnableAdaptiveMonitoring() || this.configuration.isEnableDeactivation();
            BlockStmt replacedStatement = this.blockBuilder.buildConstructorStatement(originalBlock, configurationRequiresReturn, parameters, type, this.transformer);
            constructor.setBody(replacedStatement);
            this.oneHasChanged = true;
        }
    }

    private int instrumentMethod(String name, MethodDeclaration method) {
        Optional body = method.getBody();
        if (body.isPresent()) {
            BlockStmt originalBlock = (BlockStmt)body.get();
            SignatureReader reader = new SignatureReader(this.unit, name + "." + method.getNameAsString());
            String signature = reader.getSignature(method);
            boolean oneMatches = this.checker.testSignatureMatch(signature);
            if (oneMatches) {
                boolean configurationRequiresReturn = this.configuration.isEnableAdaptiveMonitoring() || this.configuration.isEnableDeactivation();
                boolean needsReturn = method.getType().toString().equals("void") && configurationRequiresReturn;
                SamplingParameters parameters = this.createParameters(signature);
                BlockStmt replacedStatement = this.blockBuilder.buildStatement(originalBlock, needsReturn, parameters, this.transformer);
                method.setBody(replacedStatement);
                this.oneHasChanged = true;
            }
        } else if (!method.isAbstract()) {
            LOG.info("Unable to instrument " + name + "." + method.getNameAsString() + " because it has no body");
        }
        return this.counterIndex;
    }

    private SamplingParameters createParameters(String signature) {
        SamplingParameters parameters = new SamplingParameters(signature, this.counterIndex);
        if (this.configuration.isAggregate()) {
            this.countersToAdd.add(parameters.getCounterName());
            this.sumsToAdd.add(parameters.getSumName());
            ++this.counterIndex;
        }
        return parameters;
    }
}

