/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import net.kieker.sourceinstrumentation.InstrumentationConfiguration;
import net.kieker.sourceinstrumentation.instrument.TypeInstrumenter;
import net.kieker.sourceinstrumentation.parseUtils.JavaParserProvider;
import net.kieker.sourceinstrumentation.parseUtils.ParseUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileInstrumenter {
    private static final Logger LOG = LogManager.getLogger(FileInstrumenter.class);
    private final CompilationUnit unit;
    private final File file;
    private final InstrumentationConfiguration configuration;

    public FileInstrumenter(File file, InstrumentationConfiguration configuration) throws FileNotFoundException {
        this.unit = JavaParserProvider.parse(file);
        this.file = file;
        this.configuration = configuration;
    }

    public void instrument() throws IOException {
        Optional packageDeclaration = this.unit.getPackageDeclaration();
        String packageName = packageDeclaration.isPresent() ? ((PackageDeclaration)packageDeclaration.get()).getNameAsString() + "." : "";
        boolean hasChanges = false;
        for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(this.unit)) {
            hasChanges |= this.handleTypeDeclaration((TypeDeclaration<?>)clazz, packageName);
        }
        for (EnumDeclaration enumDecl : ParseUtil.getEnums(this.unit)) {
            hasChanges |= this.handleTypeDeclaration((TypeDeclaration<?>)enumDecl, packageName);
        }
        if (hasChanges) {
            this.addImports(this.unit);
            Files.write(this.file.toPath(), this.unit.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    private boolean handleTypeDeclaration(TypeDeclaration<?> type, String packageName) throws IOException {
        TypeInstrumenter instrumenter = new TypeInstrumenter(this.configuration, this.unit, type);
        boolean hasChanged = instrumenter.handleTypeDeclaration(type, packageName);
        return hasChanged;
    }

    private void addImports(CompilationUnit unit) {
        unit.addImport("kieker.monitoring.core.controller.MonitoringController");
        unit.addImport("kieker.monitoring.core.registry.ControlFlowRegistry");
        unit.addImport("kieker.monitoring.core.registry.SessionRegistry");
        unit.addImport(this.configuration.getUsedRecord().getRecord());
    }
}

