/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import net.kieker.sourceinstrumentation.instrument.codeblocks.CodeBlockTransformer;

public class SamplingParameters {
    private final String counterName;
    private final String sumName;
    private final String signature;

    public SamplingParameters(String signature, int counterIndex) {
        String nameBeforeParanthesis = signature.substring(0, signature.indexOf(40));
        String methodNameSubstring = nameBeforeParanthesis.substring(nameBeforeParanthesis.lastIndexOf(46) + 1);
        if (methodNameSubstring.equals("<init>")) {
            this.counterName = "_kieker_sourceInstrumentation_initCounter" + counterIndex;
            this.sumName = "_kieker_sourceInstrumentation_initSum" + counterIndex;
        } else {
            this.counterName = "_kieker_sourceInstrumentation_" + methodNameSubstring + "Counter" + counterIndex;
            this.sumName = "_kieker_sourceInstrumentation_" + methodNameSubstring + "Sum" + counterIndex;
        }
        this.signature = signature;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public String getSumName() {
        return this.sumName;
    }

    public String getFinalBlock(TypeDeclaration<?> type, String signature, int count) {
        if (type instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration declaration = (ClassOrInterfaceDeclaration)type;
            if (declaration.isInterface()) {
                return this.getPrefixedBlock(signature, count);
            }
            return this.getBlock(signature, count, this.sumName, this.counterName);
        }
        return this.getPrefixedBlock(signature, count);
    }

    private String getPrefixedBlock(String signature, int count) {
        String localCounterName = "_Kieker_Values." + this.counterName;
        String localSumName = "_Kieker_Values." + this.sumName;
        String basicBlock = this.getBlock(signature, count, localSumName, localCounterName);
        return CodeBlockTransformer.replaceStaticVariablesByClassStaticVariables(basicBlock);
    }

    private String getBlock(String signature, int count, String localSumName, String localCounterName) {
        return "// measure after\n         final long _kieker_sourceInstrumentation_tout = _kieker_sourceInstrumentation_TIME_SOURCE.getTime();\n        " + localSumName + "+=_kieker_sourceInstrumentation_tout-_kieker_sourceInstrumentation_tin;\nif (" + localCounterName + "++%" + count + "==0){\nfinal String _kieker_sourceInstrumentation_signature = \"" + signature + "\";\nfinal long _kieker_sourceInstrumentation_calculatedTout=_kieker_sourceInstrumentation_tin+" + localSumName + ";\n_kieker_sourceInstrumentation_controller.newMonitoringRecord(new DurationRecord(_kieker_sourceInstrumentation_signature, _kieker_sourceInstrumentation_tin, _kieker_sourceInstrumentation_calculatedTout));\n" + localSumName + "=0;}\n";
    }

    public String getSignature() {
        return this.signature;
    }
}

