/*
 * Decompiled with CFR 0.152.
 */
package net.kieker.sourceinstrumentation.instrument;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import kieker.monitoring.core.signaturePattern.InvalidPatternException;
import kieker.monitoring.core.signaturePattern.PatternParser;
import net.kieker.sourceinstrumentation.instrument.FileInstrumenter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureMatchChecker {
    private static final Logger LOG = LogManager.getLogger(FileInstrumenter.class);
    private final Set<String> includes;
    private final Set<Pattern> includePatterns = new HashSet<Pattern>();
    private final Set<String> excludes;
    private final Set<Pattern> excludePatterns = new HashSet<Pattern>();

    public SignatureMatchChecker(Set<String> includes, Set<String> excludes) {
        this.includes = includes;
        this.excludes = excludes;
        this.populatePatternSet(includes, this.includePatterns);
        this.populatePatternSet(excludes, this.excludePatterns);
    }

    private void populatePatternSet(Set<String> stringPatterns, Set<Pattern> patternSet) {
        if (stringPatterns != null) {
            for (String include : stringPatterns) {
                String pattern = this.fixConstructorPattern(include);
                try {
                    Pattern patternP = PatternParser.parseToPattern((String)pattern);
                    patternSet.add(patternP);
                }
                catch (InvalidPatternException e) {
                    throw new RuntimeException("Was not able to parse pattern " + include, e);
                }
            }
        }
    }

    public boolean testSignatureMatch(String signature) {
        boolean oneMatches = false;
        oneMatches = this.includes == null ? true : this.oneIncludeMatches(signature, oneMatches);
        if (oneMatches && this.excludes != null) {
            oneMatches = this.oneExcludeMatches(signature, oneMatches);
        }
        return oneMatches;
    }

    private boolean oneExcludeMatches(String signature, boolean oneMatches) {
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(signature).matches()) continue;
            oneMatches = false;
            break;
        }
        return oneMatches;
    }

    private boolean oneIncludeMatches(String signature, boolean oneMatches) {
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(signature).matches()) continue;
            oneMatches = true;
            break;
        }
        return oneMatches;
    }

    private String fixConstructorPattern(String pattern) {
        if (((String)pattern).contains("<init>")) {
            String returnType;
            String[] tokens = ((String)pattern).substring(0, ((String)pattern).indexOf(40)).trim().split("\\s+");
            int returnTypeIndex = 0;
            String modifier = "";
            if (tokens[0].equals("private") || tokens[0].equals("public") || tokens[0].equals("protected")) {
                ++returnTypeIndex;
                modifier = tokens[0];
            }
            if ((returnType = tokens[returnTypeIndex]).equals("new")) {
                String patternChanged = modifier + " *" + ((String)pattern).substring(((String)pattern).indexOf("new") + 3);
                LOG.trace("Changing pattern {} to {}, since Kieker 1.14 does not allow pattern with new", pattern, (Object)patternChanged);
                pattern = patternChanged;
            }
        }
        return pattern;
    }
}

