/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.junit.rule.KoPeMeStandardRuleStatement;
import de.dagere.kopeme.junit.rule.TestRunnables;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.function.ThrowingRunnable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class KoPeMeRule
implements TestRule {
    private static final Logger LOG = LogManager.getLogger(KoPeMeRule.class);
    private final Object testObject;
    private KoPeMeStandardRuleStatement koPeMeStandardRuleStatement;

    public KoPeMeRule(Object testObject) {
        this.testObject = testObject;
    }

    public Statement apply(final Statement stmt, Description descr) {
        if (descr.isTest()) {
            Method testMethod = null;
            Class<?> testClass = null;
            try {
                testClass = this.testObject.getClass();
                testMethod = testClass.getMethod(descr.getMethodName(), new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
            PerformanceTest annotation = testMethod.getAnnotation(PerformanceTest.class);
            if (annotation != null) {
                ThrowingRunnable testRunnable = new ThrowingRunnable(){

                    public void run() throws Throwable {
                        stmt.evaluate();
                    }
                };
                TestRunnables runnables = new TestRunnables(new RunConfiguration(annotation), testRunnable, testClass, this.testObject);
                this.koPeMeStandardRuleStatement = new KoPeMeStandardRuleStatement(runnables, testMethod, testClass.getName());
                return this.koPeMeStandardRuleStatement;
            }
            return stmt;
        }
        return stmt;
    }
}

