/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.Finishable;
import de.dagere.kopeme.PerformanceTestUtils;
import de.dagere.kopeme.TimeBoundExecution;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.datastorage.SaveableTestData;
import de.dagere.kopeme.junit.rule.KoPeMeBasicStatement;
import de.dagere.kopeme.junit.rule.TestRunnables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KoPeMeStandardRuleStatement
extends KoPeMeBasicStatement {
    private static final Logger LOG = LogManager.getLogger(KoPeMeStandardRuleStatement.class);
    private final TestResult finalResult;

    public KoPeMeStandardRuleStatement(TestRunnables runnables, Method method, String filename) {
        super(runnables, method, filename);
        this.finalResult = new TestResult(method.getName(), this.annotation.warmup(), this.datacollectors, false);
    }

    public void evaluate() throws Throwable {
        Finishable finishable = new Finishable(){

            public void run() {
                try {
                    KoPeMeStandardRuleStatement.this.executeSimpleTest();
                    if (!KoPeMeStandardRuleStatement.this.assertationvalues.isEmpty()) {
                        KoPeMeStandardRuleStatement.this.finalResult.checkValues(KoPeMeStandardRuleStatement.this.assertationvalues);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }

            public boolean isFinished() {
                return KoPeMeStandardRuleStatement.this.isFinished;
            }

            public void setFinished(boolean isFinished) {
                KoPeMeStandardRuleStatement.this.isFinished = isFinished;
            }
        };
        TimeBoundExecution tbe = new TimeBoundExecution(finishable, (long)this.annotation.timeout(), TimeBoundExecution.Type.METHOD, this.annotation.useKieker());
        tbe.execute();
        LOG.info("Test {} beendet", (Object)this.filename);
    }

    private void executeSimpleTest() throws Throwable {
        if (!PerformanceTestUtils.checkCollectorValidity((TestResult)this.finalResult, (Map)this.assertationvalues, (Map)this.maximalRelativeStandardDeviation)) {
            LOG.warn("Not all Collectors are valid!");
        }
        RunConfiguration configuration = new RunConfiguration(this.annotation);
        try {
            this.runWarmup();
            if (!this.isFinished) {
                this.runMainExecution(this.finalResult, "execution ", this.annotation.iterations(), this.annotation.repetitions());
            }
        }
        catch (AssertionFailedError t) {
            this.finalResult.finalizeCollection((Throwable)t);
            PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createAssertFailedTestData((String)this.finalResult.getMethodName(), (String)this.filename, (TestResult)this.finalResult, (RunConfiguration)configuration));
            throw t;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.finalResult.finalizeCollection(t);
            PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createErrorTestData((String)this.finalResult.getMethodName(), (String)this.filename, (TestResult)this.finalResult, (RunConfiguration)configuration));
            throw t;
        }
        this.finalResult.finalizeCollection();
        PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createFineTestData((String)this.finalResult.getMethodName(), (String)this.filename, (TestResult)this.finalResult, (RunConfiguration)configuration));
    }

    private void runWarmup() throws Throwable {
        if (this.annotation.warmup() > 0) {
            TestResult deletableResult = new TestResult(this.method.getName(), this.annotation.warmup(), this.datacollectors, true);
            this.runMainExecution(deletableResult, "warmup execution ", this.annotation.warmup(), this.annotation.repetitions());
            deletableResult.deleteTempFile();
        }
    }
}

