/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.junit.rule.BeforeAfterMethodRunnable;
import de.dagere.kopeme.junit.rule.ListOfMethodRunnable;
import de.dagere.kopeme.junit.rule.annotations.AfterNoMeasurement;
import de.dagere.kopeme.junit.rule.annotations.BeforeNoMeasurement;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.function.ThrowingRunnable;

public class TestRunnables {
    private static final Logger LOG = LogManager.getLogger(TestRunnables.class);
    private final ThrowingRunnable testRunnable;
    private final ThrowingRunnable beforeRunnable;
    private final ThrowingRunnable afterRunnable;

    public TestRunnables(RunConfiguration config, ThrowingRunnable testRunnable, Class<?> testClass, Object testObject) {
        LinkedList<Method> beforeMethods = new LinkedList<Method>();
        LinkedList<Method> afterMethods = new LinkedList<Method>();
        LOG.debug("Klasse: {}", testClass);
        for (Method classMethod : testClass.getMethods()) {
            LOG.trace("Pr\u00fcfe: {}", (Object)classMethod);
            if (classMethod.getAnnotation(BeforeNoMeasurement.class) != null) {
                if (classMethod.getParameterTypes().length > 0) {
                    throw new RuntimeException("BeforeNoMeasurement-methods must not have arguments");
                }
                beforeMethods.add(classMethod);
            }
            if (classMethod.getAnnotation(AfterNoMeasurement.class) == null) continue;
            if (classMethod.getParameterTypes().length > 0) {
                throw new RuntimeException("AfterNoMeasurement-methods must not have arguments");
            }
            afterMethods.add(classMethod);
        }
        if (config.isExecuteBeforeClassInMeasurement()) {
            LinkedList<Method> beforeClassMethod = new LinkedList<Method>();
            LinkedList<Method> afterClassMethod = new LinkedList<Method>();
            for (Method classMethod : testClass.getMethods()) {
                if (classMethod.getAnnotation(BeforeClass.class) != null) {
                    beforeClassMethod.add(classMethod);
                }
                if (classMethod.getAnnotation(AfterClass.class) == null) continue;
                afterClassMethod.add(classMethod);
            }
            this.testRunnable = new BeforeAfterMethodRunnable(beforeClassMethod, testRunnable, afterClassMethod, testObject);
        } else {
            this.testRunnable = testRunnable;
        }
        this.beforeRunnable = new ListOfMethodRunnable(beforeMethods, testObject);
        this.afterRunnable = new ListOfMethodRunnable(afterMethods, testObject);
    }

    public ThrowingRunnable getTestRunnable() {
        return this.testRunnable;
    }

    public ThrowingRunnable getBeforeRunnable() {
        return this.beforeRunnable;
    }

    public ThrowingRunnable getAfterRunnable() {
        return this.afterRunnable;
    }
}

