/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit5.rule;

import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.junit.rule.KoPeMeStandardRuleStatement;
import de.dagere.kopeme.junit.rule.TestRunnables;
import de.dagere.kopeme.junit5.rule.DummyConfiguration;
import java.lang.reflect.Method;
import org.junit.function.ThrowingRunnable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.jupiter.engine.support.JupiterThrowableCollectorFactory;
import org.junit.platform.engine.UniqueId;

public class KoPeMeJUnit5Starter {
    private final ExtensionContext context;
    private final UniqueId currentId = UniqueId.forEngine((String)"junit-jupiter");
    private final Object instance;
    private final Method method;
    private final JupiterConfiguration configuration;

    public KoPeMeJUnit5Starter(ExtensionContext context) {
        this.context = context;
        this.instance = context.getTestInstance().get();
        this.method = (Method)context.getTestMethod().get();
        this.configuration = this.getDummyConfiguration();
    }

    public void start() throws Exception {
        final TestMethodTestDescriptor descriptor = new TestMethodTestDescriptor(this.currentId, this.instance.getClass(), this.method, this.configuration);
        final JupiterEngineExecutionContext jupiterContext = this.prepareJUnit5(descriptor);
        try {
            ThrowingRunnable throwingRunnable = new ThrowingRunnable(){

                public void run() throws Throwable {
                    descriptor.execute(jupiterContext, null);
                }
            };
            RunConfiguration runConfiguration = new RunConfiguration(this.method.getAnnotation(PerformanceTest.class));
            TestRunnables runnables = new TestRunnables(runConfiguration, throwingRunnable, this.instance.getClass(), this.instance);
            KoPeMeStandardRuleStatement statement = new KoPeMeStandardRuleStatement(runnables, this.method, this.instance.getClass().getName());
            statement.evaluate();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private JupiterEngineExecutionContext prepareJUnit5(TestMethodTestDescriptor descriptor) {
        MutableExtensionRegistry extensionRegistry = MutableExtensionRegistry.createRegistryWithDefaultExtensions((JupiterConfiguration)this.configuration);
        JupiterEngineExecutionContext kopemeContext = new JupiterEngineExecutionContext(null, this.configuration).extend().withExtensionRegistry(extensionRegistry).withExtensionContext(this.context).withThrowableCollector(JupiterThrowableCollectorFactory.createThrowableCollector()).build();
        ClassTestDescriptor classDescriptor = new ClassTestDescriptor(this.currentId, this.instance.getClass(), this.configuration);
        JupiterEngineExecutionContext clazzContext = classDescriptor.prepare(kopemeContext);
        JupiterEngineExecutionContext methodContext = descriptor.prepare(clazzContext);
        return methodContext;
    }

    private JupiterConfiguration getDummyConfiguration() {
        DummyConfiguration configuration = new DummyConfiguration();
        return configuration;
    }
}

