/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.Finishable;
import de.dagere.kopeme.PerformanceTestUtils;
import de.dagere.kopeme.TimeBoundExecution;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.datastorage.ParamNameHelper;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.datastorage.SaveableTestData;
import de.dagere.kopeme.generated.Result;
import de.dagere.kopeme.junit.rule.KoPeMeBasicStatement;
import de.dagere.kopeme.runnables.TestRunnable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KoPeMeStandardRuleStatement
extends KoPeMeBasicStatement {
    private static final Logger LOG = LogManager.getLogger(KoPeMeStandardRuleStatement.class);
    public static final String KOPEME_CHOSEN_PARAMETER_INDEX = "KOPEME_CHOSEN_PARAMETER_INDEX";
    private final TestResult finalResult;
    private final Result.Params params;

    public KoPeMeStandardRuleStatement(TestRunnable runnables, Method method, String filename) {
        super(runnables, method, filename, method.getName());
        this.finalResult = new TestResult(method.getName(), this.annotation.warmup(), this.datacollectors, false);
        this.params = null;
        this.initializeKieker(this.clazzname, method.getName());
    }

    public KoPeMeStandardRuleStatement(TestRunnable runnables, Method method, String filename, Result.Params params) {
        super(runnables, method, filename, params != null ? method.getName() + "(" + ParamNameHelper.paramsToString((Result.Params)params) + ")" : method.getName());
        this.finalResult = new TestResult(method.getName(), this.annotation.warmup(), this.datacollectors, false, params);
        this.params = params;
        if (!this.parameterIndexInvalid()) {
            String methodFileName = params != null ? method.getName() + "(" + ParamNameHelper.paramsToString((Result.Params)params) + ")" : method.getName();
            this.initializeKieker(this.clazzname, methodFileName);
        }
    }

    public void evaluate() throws Throwable {
        boolean parameterIndexInvalid = this.parameterIndexInvalid();
        if (parameterIndexInvalid) {
            return;
        }
        Finishable finishable = new Finishable(){

            public void run() {
                try {
                    KoPeMeStandardRuleStatement.this.executeSimpleTest();
                    if (!KoPeMeStandardRuleStatement.this.assertationvalues.isEmpty()) {
                        KoPeMeStandardRuleStatement.this.finalResult.checkValues(KoPeMeStandardRuleStatement.this.assertationvalues);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }

            public boolean isFinished() {
                return KoPeMeStandardRuleStatement.this.isFinished;
            }

            public void setFinished(boolean isFinished) {
                KoPeMeStandardRuleStatement.this.isFinished = isFinished;
            }
        };
        TimeBoundExecution tbe = new TimeBoundExecution(finishable, (long)this.annotation.timeout(), TimeBoundExecution.Type.METHOD, this.annotation.useKieker());
        tbe.execute();
        LOG.info("Test {} beendet", (Object)this.clazzname);
    }

    private boolean parameterIndexInvalid() {
        int environmentChosenIndex;
        int chosenParameterIndex = this.annotation.chosenParameterIndex();
        if (chosenParameterIndex != -1 && chosenParameterIndex != Integer.parseInt(((Result.Params.Param)this.params.getParam().get(0)).getValue())) {
            System.out.println("Test was disabled because of chosen parameter index (parameter) " + chosenParameterIndex);
            System.out.println("Current index: " + ((Result.Params.Param)this.params.getParam().get(0)).getValue());
            return true;
        }
        String chosenParameterIndexEnvironment = System.getenv(KOPEME_CHOSEN_PARAMETER_INDEX);
        if (chosenParameterIndexEnvironment != null && (environmentChosenIndex = Integer.parseInt(chosenParameterIndexEnvironment)) != -1 && environmentChosenIndex != Integer.parseInt(((Result.Params.Param)this.params.getParam().get(0)).getValue())) {
            System.out.println("Test was disabled because of chosen parameter index (environment variable) " + environmentChosenIndex);
            System.out.println("Current index: " + ((Result.Params.Param)this.params.getParam().get(0)).getValue());
            return true;
        }
        return false;
    }

    private void executeSimpleTest() throws Throwable {
        if (!PerformanceTestUtils.checkCollectorValidity((TestResult)this.finalResult, (Map)this.assertationvalues, (Map)this.maximalRelativeStandardDeviation)) {
            LOG.warn("Not all Collectors are valid!");
        }
        RunConfiguration configuration = new RunConfiguration(this.annotation);
        try {
            this.runWarmup();
            if (!this.isFinished) {
                this.runMainExecution(this.finalResult, "execution ", this.annotation.iterations(), this.annotation.repetitions());
            }
        }
        catch (AssertionFailedError t) {
            this.finalResult.finalizeCollection((Throwable)t);
            PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createAssertFailedTestData((String)this.finalResult.getMethodName(), (String)this.clazzname, (TestResult)this.finalResult, (RunConfiguration)configuration));
            throw t;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.finalResult.finalizeCollection(t);
            PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createErrorTestData((String)this.finalResult.getMethodName(), (String)this.clazzname, (TestResult)this.finalResult, (RunConfiguration)configuration));
            throw t;
        }
        this.finalResult.finalizeCollection();
        PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createFineTestData((String)this.finalResult.getMethodName(), (String)this.clazzname, (TestResult)this.finalResult, (RunConfiguration)configuration));
    }

    private void runWarmup() throws Throwable {
        if (this.annotation.warmup() > 0) {
            TestResult deletableResult = new TestResult(this.method.getName(), this.annotation.warmup(), this.datacollectors, true);
            this.runMainExecution(deletableResult, "warmup execution ", this.annotation.warmup(), this.annotation.repetitions());
            deletableResult.deleteTempFile();
        }
    }
}

