/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.runnables;

import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.junit.rule.BeforeAfterMethodFinder;
import de.dagere.kopeme.runnables.BeforeAfterMethodRunnable;
import de.dagere.kopeme.runnables.ListOfMethodRunnable;
import de.dagere.kopeme.runnables.TestRunnable;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.function.ThrowingRunnable;

public class TestRunnables
implements TestRunnable {
    private static final Logger LOG = LogManager.getLogger(TestRunnables.class);
    private final ThrowingRunnable testRunnable;
    private final ThrowingRunnable beforeRunnable;
    private final ThrowingRunnable afterRunnable;

    public TestRunnables(RunConfiguration config, ThrowingRunnable testRunnable, Class<?> testClass, Object testObject) {
        List<Method> beforeMethods = BeforeAfterMethodFinder.getBeforeNoMeasurements(testClass);
        List<Method> afterMethods = BeforeAfterMethodFinder.getAfterNoMeasurements(testClass);
        LOG.debug("Klasse: {}", testClass);
        if (config.isExecuteBeforeClassInMeasurement()) {
            List<Method> beforeClassMethod = BeforeAfterMethodFinder.getBeforeWithMeasurements(testClass);
            List<Method> afterClassMethod = BeforeAfterMethodFinder.getAfterWithMeasurements(testClass);
            this.testRunnable = new BeforeAfterMethodRunnable(beforeClassMethod, testRunnable, afterClassMethod, testObject);
        } else {
            this.testRunnable = testRunnable;
        }
        this.beforeRunnable = new ListOfMethodRunnable(beforeMethods, testObject);
        this.afterRunnable = new ListOfMethodRunnable(afterMethods, testObject);
    }

    @Override
    public ThrowingRunnable getTestRunnable() {
        return this.testRunnable;
    }

    @Override
    public ThrowingRunnable getBeforeRunnable() {
        return this.beforeRunnable;
    }

    @Override
    public ThrowingRunnable getAfterRunnable() {
        return this.afterRunnable;
    }
}

