/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.generated.Result;
import de.dagere.kopeme.junit.rule.KoPeMeStandardRuleStatement;
import de.dagere.kopeme.runnables.TestRunnable;
import de.dagere.kopeme.runnables.TestRunnables;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.function.ThrowingRunnable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class KoPeMeRule
implements TestRule {
    public static final String JUNIT_PARAMETERIZED = "JUNIT_PARAMETERIZED";
    private static final Logger LOG = LogManager.getLogger(KoPeMeRule.class);
    private final Object testObject;
    private KoPeMeStandardRuleStatement koPeMeStandardRuleStatement;

    public KoPeMeRule(Object testObject) {
        this.testObject = testObject;
    }

    public Statement apply(final Statement stmt, Description descr) {
        if (descr.isTest()) {
            Method testMethod = null;
            Class<?> testClass = null;
            try {
                Result.Params params;
                testClass = this.testObject.getClass();
                String methodDescription = descr.getMethodName();
                int squaredBracketIndex = methodDescription.indexOf(91);
                if (squaredBracketIndex != -1) {
                    String methodName = methodDescription.substring(0, squaredBracketIndex);
                    params = this.parseParams(methodDescription, squaredBracketIndex);
                    testMethod = testClass.getMethod(methodName, new Class[0]);
                } else {
                    testMethod = testClass.getMethod(methodDescription, new Class[0]);
                    params = null;
                }
                PerformanceTest annotation = testMethod.getAnnotation(PerformanceTest.class);
                if (annotation != null) {
                    ThrowingRunnable testRunnable = new ThrowingRunnable(){

                        public void run() throws Throwable {
                            stmt.evaluate();
                        }
                    };
                    TestRunnables runnables = new TestRunnables(new RunConfiguration(annotation), testRunnable, testClass, this.testObject);
                    this.koPeMeStandardRuleStatement = new KoPeMeStandardRuleStatement((TestRunnable)runnables, testMethod, testClass.getName(), params);
                    return this.koPeMeStandardRuleStatement;
                }
                return stmt;
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
                return null;
            }
        }
        return stmt;
    }

    private Result.Params parseParams(String methodDescription, int squaredBracketIndex) {
        String indexString = methodDescription.substring(squaredBracketIndex + 1, methodDescription.length() - 1);
        Result.Params params = new Result.Params();
        Result.Params.Param param = new Result.Params.Param();
        param.setKey(JUNIT_PARAMETERIZED);
        param.setValue(indexString);
        params.getParam().add(param);
        return params;
    }
}

