/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.runnables;

import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.junit.rule.BeforeAfterMethodFinder;
import de.dagere.kopeme.runnables.BeforeAfterMethodRunnable;
import de.dagere.kopeme.runnables.ListOfMethodRunnable;
import de.dagere.kopeme.runnables.TestRunnable;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.function.ThrowingRunnable;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class PreparableTestRunnables
implements TestRunnable {
    private final List<Method> beforeMethods;
    private final List<Method> afterMethods;
    private final RunConfiguration config;
    private final Class<?> testClass;
    private final TestMethodTestDescriptor descriptor;
    private final JupiterEngineExecutionContext jupiterContext;
    private Object instance;
    private ThrowingRunnable innerRunnable;

    public PreparableTestRunnables(RunConfiguration config, Class<?> testClass, TestMethodTestDescriptor descriptor, JupiterEngineExecutionContext jupiterContext) {
        this.config = config;
        this.testClass = testClass;
        this.beforeMethods = BeforeAfterMethodFinder.getBeforeNoMeasurements(testClass);
        this.afterMethods = BeforeAfterMethodFinder.getAfterNoMeasurements(testClass);
        this.descriptor = descriptor;
        this.jupiterContext = jupiterContext;
    }

    public void prepare() {
        final JupiterEngineExecutionContext methodContext = this.descriptor.prepare(this.jupiterContext);
        this.instance = methodContext.getExtensionContext().getTestInstance().get();
        this.innerRunnable = new ThrowingRunnable(){

            public void run() throws Throwable {
                PreparableTestRunnables.this.descriptor.execute(methodContext, null);
                methodContext.close();
                if (!methodContext.getThrowableCollector().isEmpty()) {
                    Method addMethod = ThrowableCollector.class.getDeclaredMethod("add", Throwable.class);
                    addMethod.setAccessible(true);
                    addMethod.invoke((Object)PreparableTestRunnables.this.jupiterContext.getThrowableCollector(), methodContext.getThrowableCollector().getThrowable());
                }
            }
        };
    }

    @Override
    public ThrowingRunnable getTestRunnable() {
        ThrowingRunnable runnable;
        if (this.config.isExecuteBeforeClassInMeasurement()) {
            List<Method> beforeClassMethod = BeforeAfterMethodFinder.getBeforeWithMeasurements(this.testClass);
            List<Method> afterClassMethod = BeforeAfterMethodFinder.getAfterWithMeasurements(this.testClass);
            runnable = new BeforeAfterMethodRunnable(beforeClassMethod, this.innerRunnable, afterClassMethod, this.instance);
        } else {
            runnable = this.innerRunnable;
        }
        return runnable;
    }

    @Override
    public ThrowingRunnable getBeforeRunnable() {
        this.prepare();
        ListOfMethodRunnable beforeRunnable = new ListOfMethodRunnable(this.beforeMethods, this.instance);
        return beforeRunnable;
    }

    @Override
    public ThrowingRunnable getAfterRunnable() {
        ListOfMethodRunnable afterRunnable = new ListOfMethodRunnable(this.afterMethods, this.instance);
        return afterRunnable;
    }
}

