/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit3;

import de.dagere.kopeme.Finishable;
import de.dagere.kopeme.OutputStreamUtil;
import de.dagere.kopeme.PerformanceTestUtils;
import de.dagere.kopeme.TimeBoundExecution;
import de.dagere.kopeme.annotations.AnnotationDefaults;
import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.annotations.PerformanceTestingClass;
import de.dagere.kopeme.datacollection.DataCollectorList;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.datastorage.SaveableTestData;
import de.dagere.kopeme.kieker.KoPeMeKiekerSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class KoPeMeTestcase
extends TestCase {
    private static final Logger LOG = LogManager.getLogger(KoPeMeTestcase.class);
    private final PerformanceTest annoTestcase = (PerformanceTest)AnnotationDefaults.of(PerformanceTest.class);
    private final PerformanceTestingClass annoTestClass = (PerformanceTestingClass)AnnotationDefaults.of(PerformanceTestingClass.class);
    private final boolean needToStopHart = false;
    private boolean isFinished;

    public KoPeMeTestcase() {
    }

    public KoPeMeTestcase(String name) {
        super(name);
    }

    protected int getWarmup() {
        return this.annoTestcase.warmup();
    }

    protected int getRepetitions() {
        return this.annoTestcase.repetitions();
    }

    protected int getIterations() {
        return this.annoTestcase.iterations();
    }

    protected boolean logFullData() {
        return this.annoTestcase.logFullData();
    }

    protected boolean showStart() {
        return false;
    }

    protected boolean redirectToTemp() {
        return false;
    }

    protected boolean redirectToNull() {
        return false;
    }

    protected boolean executeBeforeClassInMeasurement() {
        return false;
    }

    protected long getMaximalTime() {
        return this.annoTestClass.overallTimeout();
    }

    protected DataCollectorList getDataCollectors() {
        return DataCollectorList.STANDARD;
    }

    protected boolean useKieker() {
        return this.annoTestcase.useKieker();
    }

    public void runBare() throws InterruptedException, IOException {
        LOG.trace("Initialize JUnit-3-KoPeMe-Testcase");
        final int warmupExecutions = this.getWarmup();
        final int executionTimes = this.getIterations();
        final boolean fullData = this.logFullData();
        long timeoutTime = this.getMaximalTime();
        String testClassName = ((Object)((Object)this)).getClass().getName();
        DataCollectorList datacollectors = this.getDataCollectors();
        final TestResult finalResult = new TestResult(testClassName, executionTimes, datacollectors, false);
        KoPeMeKiekerSupport.INSTANCE.useKieker(this.useKieker(), testClassName, this.getName());
        Finishable finishable = new Finishable(){

            public void run() {
                try {
                    KoPeMeTestcase.this.runTestCase(finalResult, warmupExecutions, executionTimes, fullData);
                }
                catch (IllegalAccessException | InvocationTargetException | AssertionFailedError e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                LOG.debug("Test-call finished");
            }

            public void setFinished(boolean isFinished) {
                KoPeMeTestcase.this.isFinished = isFinished;
            }

            public boolean isFinished() {
                return KoPeMeTestcase.this.isFinished;
            }
        };
        RunConfiguration configuration = new RunConfiguration(this.getWarmup(), this.getRepetitions(), this.showStart(), this.redirectToTemp(), this.redirectToNull(), this.logFullData(), this.executeBeforeClassInMeasurement());
        TimeBoundExecution tbe = new TimeBoundExecution(finishable, timeoutTime, TimeBoundExecution.Type.METHOD, this.useKieker());
        try {
            boolean finished = tbe.execute();
            if (!finished) {
                SaveableTestData.TestErrorTestData errorTestData = SaveableTestData.createErrorTestData((String)this.getName(), (String)((Object)((Object)this)).getClass().getName(), (TestResult)finalResult, (RunConfiguration)configuration);
                LOG.debug("Data created");
                PerformanceTestUtils.saveData((SaveableTestData)errorTestData);
                KoPeMeTestcase.fail((String)"Test took too long.");
            } else {
                PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createFineTestData((String)this.getName(), (String)((Object)((Object)this)).getClass().getName(), (TestResult)finalResult, (RunConfiguration)configuration));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            KoPeMeTestcase.fail((String)e.getLocalizedMessage());
        }
    }

    private void runTestCase(TestResult tr, int warmupExecutions, int executionTimes, boolean fullData) throws Throwable {
        String fullName = ((Object)((Object)this)).getClass().getName() + "." + this.getName();
        try {
            TestResult bulkResult = new TestResult(tr.getTestcase(), executionTimes, this.getDataCollectors(), true);
            this.runMainExecution("warmup", fullName, bulkResult, warmupExecutions);
            this.runMainExecution("main", fullName, tr, executionTimes);
            LOG.debug("Finalizing..");
            tr.finalizeCollection();
        }
        catch (AssertionFailedError t) {
            LOG.error("An error occurred; saving data and finishing");
            tr.finalizeCollection((Throwable)t);
            throw t;
        }
        catch (Throwable t) {
            LOG.error("An error occurred; saving data and finishing");
            tr.finalizeCollection(t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runMainExecution(String executionTypName, String name, TestResult tr, int executionTimes) throws Throwable {
        System.gc();
        String firstPart = "--- Starting " + executionTypName + " execution " + name + " ";
        String firstPartStop = "--- Stopping " + executionTypName + " execution ";
        String endPart = "/" + executionTimes + " ---";
        int repetitions = this.getRepetitions();
        tr.beforeRun();
        int execution = 1;
        try {
            if (this.redirectToTemp()) {
                this.redirectToTempFile();
            } else if (this.redirectToNull()) {
                OutputStreamUtil.redirectToNullStream();
            }
            for (execution = 1; execution <= executionTimes; ++execution) {
                if (this.showStart()) {
                    LOG.debug(firstPart + execution + endPart);
                }
                tr.startCollection();
                this.runAllRepetitions(repetitions);
                tr.stopCollection();
                tr.setRealExecutions(execution);
                if (this.showStart()) {
                    LOG.debug(firstPartStop + execution + endPart);
                }
                this.checkFinished();
            }
        }
        finally {
            OutputStreamUtil.resetStreams();
        }
        System.gc();
        Thread.sleep(1L);
        LOG.debug("Executions: " + (execution - 1));
        tr.setRealExecutions(execution - 1);
    }

    private void redirectToTempFile() throws IOException, FileNotFoundException {
        File tempFile = Files.createTempFile("kopeme", ".txt", new FileAttribute[0]).toFile();
        PrintStream stream = new PrintStream(tempFile);
        System.setOut(stream);
        System.setErr(stream);
    }

    private void checkFinished() throws InterruptedException {
        if (this.isFinished) {
            LOG.debug("Exiting finished thread: {}.", (Object)Thread.currentThread().getName());
            throw new InterruptedException("Test timed out.");
        }
        boolean interrupted = Thread.interrupted();
        LOG.trace("Interrupt state: {}", (Object)interrupted);
        if (interrupted) {
            LOG.debug("Exiting thread.");
            throw new InterruptedException("Test was interrupted and eventually timed out.");
        }
    }

    private void runAllRepetitions(int repetitions) throws Exception, Throwable {
        for (int repetion = 0; repetion < repetitions; ++repetion) {
            this.setUp();
            KoPeMeTestcase.super.runTest();
            this.tearDown();
            if (Thread.currentThread().isInterrupted()) break;
        }
    }
}

