/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit3;

import de.dagere.kopeme.PerformanceTestUtils;
import de.dagere.kopeme.datacollection.DataCollectorList;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.datastorage.SaveableTestData;
import de.dagere.kopeme.junit3.KoPeMeTestcase;
import java.util.LinkedList;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TimeBasedTestcase
extends KoPeMeTestcase {
    private static final int NANOTOMIKRO = 1000;
    private static final Logger LOG = LogManager.getLogger(TimeBasedTestcase.class);

    public TimeBasedTestcase() {
    }

    public TimeBasedTestcase(String name) {
        super(name);
    }

    @Override
    public int getRepetitions() {
        return 200;
    }

    public abstract long getDuration();

    @Override
    public void runBare() throws InterruptedException {
        LOG.trace("Running TimeBasedTestcase");
        long durationInMilliseconds = this.getDuration();
        LOG.debug("Duration: " + durationInMilliseconds);
        String testClassName = ((Object)((Object)this)).getClass().getName();
        long maximumDuration = durationInMilliseconds * 1000L * 1000L;
        TestResult tr = new TestResult(testClassName, -1, DataCollectorList.ONLYTIME, false);
        int executionTimes = this.calibrateMeasurement("warmup", testClassName, tr, maximumDuration);
        String fullName = ((Object)((Object)this)).getClass().getName() + "." + this.getName();
        try {
            this.runMainExecution("main", fullName, tr, executionTimes);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        LOG.debug("KoPeMe-Test {} finished", (Object)this.getName());
        PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createFineTestData((String)this.getName(), (String)((Object)((Object)this)).getClass().getName(), (TestResult)tr, (RunConfiguration)new RunConfiguration(0, 0, this.showStart(), this.redirectToTemp(), this.redirectToNull(), true, false)));
    }

    private int calibrateMeasurement(String executionTypName, String name, TestResult tr, long maximumDuration) {
        try {
            long basicDuration;
            long calibration;
            long value2;
            long calibrationStart = System.nanoTime();
            long emptyDuration = this.measureNTimes(executionTypName, name, tr, 0);
            LinkedList<Long> calibrationValues = new LinkedList<Long>();
            for (calibration = basicDuration = this.measureNTimes(executionTypName, name, tr, 1); calibration < maximumDuration / 2L; calibration += value2) {
                value2 = this.measureNTimes(executionTypName, name, tr, 1);
                calibrationValues.add(value2);
            }
            DescriptiveStatistics statistics = new DescriptiveStatistics();
            calibrationValues.forEach(value -> statistics.addValue((double)value.longValue()));
            LOG.debug("Mean: " + statistics.getMean() / 1000.0 + " " + statistics.getPercentile(20.0) / 1000.0 + " Calibration time: " + calibration / 1000L);
            LOG.debug("Empty: {} Per-Execution-Duration: {}", (Object)(emptyDuration / 1000L), (Object)(Math.abs(statistics.getMean() - (double)emptyDuration) / 1000.0));
            long halfTime = maximumDuration / 2L;
            double estimatedExecutionDuration = Math.abs(statistics.getMean() - (double)emptyDuration);
            LOG.debug("Estimated Execution Duration: {} Half-Time: {}", (Object)(estimatedExecutionDuration / 1000.0), (Object)(halfTime / 1000L));
            int executions = (int)((double)halfTime / ((double)emptyDuration + estimatedExecutionDuration));
            LOG.debug("Executions: {}", (Object)executions, (Object)((double)maximumDuration / statistics.getMean()));
            long calibrationEnd = System.nanoTime();
            LOG.debug("Duration of calibration: {}", (Object)((calibrationEnd - calibrationStart) / 1000L));
            return executions;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 1;
        }
    }

    private long measureNTimes(String executionTypName, String name, TestResult tr, int n) throws Throwable {
        long overheadStart = System.nanoTime();
        this.runMainExecution(executionTypName, name, tr, n);
        long overheadEnd = System.nanoTime();
        return overheadEnd - overheadStart;
    }
}

