/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.testrunner;

import de.dagere.kopeme.Finishable;
import de.dagere.kopeme.TimeBoundExecution;
import de.dagere.kopeme.annotations.AnnotationDefaults;
import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.annotations.PerformanceTestingClass;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.junit.testrunner.PerformanceMethodStatement;
import de.dagere.kopeme.runnables.KoPeMeThrowingRunnable;
import de.dagere.kopeme.runnables.TestRunnable;
import de.dagere.kopeme.runnables.TestRunnables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class PerformanceTestRunnerJUnit
extends BlockJUnit4ClassRunner {
    private static final PerformanceTestingClass DEFAULTPERFORMANCETESTINGCLASS = (PerformanceTestingClass)AnnotationDefaults.of(PerformanceTestingClass.class);
    private static final Logger LOG = LogManager.getLogger(PerformanceTestRunnerJUnit.class);
    protected final Class<?> klasse;
    protected boolean logFullDataClass;
    protected FrameworkMethod method;
    protected final String filename;
    protected boolean classFinished = false;
    protected PerformanceMethodStatement currentMethodStatement;

    public PerformanceTestRunnerJUnit(Class<?> klasse) throws InitializationError {
        super(klasse);
        this.klasse = klasse;
        this.filename = klasse.getName();
    }

    public void run(final RunNotifier notifier) {
        long start = System.nanoTime();
        PerformanceTestingClass ptc = this.klasse.getAnnotation(PerformanceTestingClass.class);
        if (ptc == null) {
            ptc = DEFAULTPERFORMANCETESTINGCLASS;
        }
        Finishable testRunRunnable = new Finishable(){

            public void run() {
                PerformanceTestRunnerJUnit.super.run(notifier);
            }

            public boolean isFinished() {
                return false;
            }

            public void setFinished(boolean isFinished) {
                PerformanceTestRunnerJUnit.this.classFinished = isFinished;
                if (PerformanceTestRunnerJUnit.this.currentMethodStatement != null) {
                    PerformanceTestRunnerJUnit.this.currentMethodStatement.setFinished(isFinished);
                }
            }
        };
        this.logFullDataClass = ptc.logFullData();
        TimeBoundExecution tbe = new TimeBoundExecution(testRunRunnable, (long)ptc.overallTimeout(), TimeBoundExecution.Type.CLASS, false);
        boolean finished = tbe.execute();
        LOG.debug("Time: " + (double)(System.nanoTime() - start) / 1.0E7 + " milliseconds");
        if (!finished) {
            this.classFinished = true;
            LOG.debug("Not finished.");
            this.setTestsToFail(notifier);
        }
    }

    protected void setTestsToFail(RunNotifier notifier) {
        Description description = this.getDescription();
        ArrayList<Description> toBeFailed = new ArrayList<Description>(description.getChildren());
        toBeFailed.add(description);
        for (Description d : toBeFailed) {
            EachTestNotifier testNotifier = new EachTestNotifier(notifier, d);
            testNotifier.addFailure((Throwable)new TimeoutException("Test timed out because of class timeout"));
        }
    }

    protected void validateTestMethods(List<Throwable> errors) {
        for (FrameworkMethod each : this.computeTestMethods()) {
            if (each.getMethod().getParameterTypes().length > 1) {
                errors.add(new Exception("Method " + each.getName() + " is supposed to have one or zero parameters, who's type is TestResult"));
                continue;
            }
            if (each.getMethod().getParameterTypes().length != 1 || each.getMethod().getParameterTypes()[0] == TestResult.class) continue;
            errors.add(new Exception("Method " + each.getName() + " has wrong parameter Type: " + each.getMethod().getParameterTypes()[0]));
        }
    }

    protected TestRunnable getStatement(FrameworkMethod currentMethod) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            Object testObject = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return PerformanceTestRunnerJUnit.this.createTest();
                }
            }.run();
            if (this.classFinished) {
                return null;
            }
            LOG.debug("Statement: " + currentMethod.getName() + " " + this.classFinished);
            Statement testExceptionTimeoutStatement = this.methodInvoker(currentMethod, testObject);
            testExceptionTimeoutStatement = this.possiblyExpectingExceptions(currentMethod, testObject, testExceptionTimeoutStatement);
            final Statement withRuleStatement = this.ruleInvoker(currentMethod, testObject, testExceptionTimeoutStatement);
            PerformanceTest annotation = (PerformanceTest)currentMethod.getAnnotation(PerformanceTest.class);
            if (annotation != null) {
                KoPeMeThrowingRunnable testRunnable = new KoPeMeThrowingRunnable(){

                    public void run() throws Throwable {
                        withRuleStatement.evaluate();
                    }
                };
                LinkedList beforeClassMethod = new LinkedList();
                LinkedList afterClassMethod = new LinkedList();
                TestRunnables runnables = new TestRunnables(new RunConfiguration(annotation), testRunnable, this.klasse, testObject, beforeClassMethod, afterClassMethod);
                return runnables;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private Statement ruleInvoker(FrameworkMethod currentMethod, Object testObject, Statement testExceptionTimeoutStatement) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method withRulesMethod = BlockJUnit4ClassRunner.class.getDeclaredMethod("withRules", FrameworkMethod.class, Object.class, Statement.class);
        withRulesMethod.setAccessible(true);
        Statement withRuleStatement = (Statement)withRulesMethod.invoke((Object)this, currentMethod, testObject, testExceptionTimeoutStatement);
        return withRuleStatement;
    }

    protected Statement methodBlock(FrameworkMethod currentMethod) {
        if (currentMethod.getAnnotation(PerformanceTest.class) == null) {
            return super.methodBlock(currentMethod);
        }
        return this.createPerformanceStatementFromMethod(currentMethod);
    }

    protected Statement createPerformanceStatementFromMethod(FrameworkMethod currentMethod) {
        try {
            TestRunnable callee = this.getStatement(currentMethod);
            LOG.trace("Im methodBlock f\u00fcr " + currentMethod.getName());
            this.method = currentMethod;
            if (!this.classFinished) {
                this.currentMethodStatement = new PerformanceMethodStatement(callee, this.filename, this.klasse, this.method, this.logFullDataClass);
                return this.currentMethodStatement;
            }
            return new Statement(){

                public void evaluate() throws Throwable {
                    throw new TimeoutException("Test timed out because of class timeout.");
                }
            };
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

