/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.junit.rule.annotations.AfterWithMeasurement;
import de.dagere.kopeme.junit.rule.annotations.BeforeWithMeasurement;
import de.dagere.kopeme.runnables.BeforeAfterMethodFinder;
import java.lang.reflect.Method;
import java.util.List;
import java.util.TreeMap;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;

public class BeforeAfterMethodFinderJUnit4
extends BeforeAfterMethodFinder {
    public static List<Method> getBeforeWithMeasurements(Class<?> testClazz) {
        TreeMap beforePriorityMethods = new TreeMap();
        for (Method classMethod : testClazz.getDeclaredMethods()) {
            BeforeWithMeasurement annotationValue = classMethod.getAnnotation(BeforeWithMeasurement.class);
            if (annotationValue != null) {
                classMethod.setAccessible(true);
                int priority = annotationValue.priority();
                BeforeAfterMethodFinderJUnit4.addToPriority(beforePriorityMethods, (Method)classMethod, (int)priority);
            }
            if (classMethod.getAnnotation(BeforeClass.class) == null && classMethod.getAnnotation(BeforeAll.class) == null) continue;
            classMethod.setAccessible(true);
            BeforeAfterMethodFinderJUnit4.addToPriority(beforePriorityMethods, (Method)classMethod, (int)Integer.MAX_VALUE);
        }
        List orderedMethodsMethod = BeforeAfterMethodFinder.buildOrderedList(beforePriorityMethods);
        return orderedMethodsMethod;
    }

    public static List<Method> getAfterWithMeasurements(Class<?> testClazz) {
        TreeMap beforePriorityMethods = new TreeMap();
        for (Method classMethod : testClazz.getDeclaredMethods()) {
            AfterWithMeasurement annotationValue = classMethod.getAnnotation(AfterWithMeasurement.class);
            if (annotationValue != null) {
                classMethod.setAccessible(true);
                int priority = annotationValue.priority();
                BeforeAfterMethodFinderJUnit4.addToPriority(beforePriorityMethods, (Method)classMethod, (int)priority);
            }
            if (classMethod.getAnnotation(AfterClass.class) == null && classMethod.getAnnotation(AfterEach.class) == null) continue;
            classMethod.setAccessible(true);
            BeforeAfterMethodFinderJUnit4.addToPriority(beforePriorityMethods, (Method)classMethod, (int)Integer.MAX_VALUE);
        }
        List orderedMethodsMethod = BeforeAfterMethodFinder.buildOrderedList(beforePriorityMethods);
        return orderedMethodsMethod;
    }
}

