/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.testrunner;

import de.dagere.kopeme.Finishable;
import de.dagere.kopeme.PerformanceTestUtils;
import de.dagere.kopeme.TimeBoundExecution;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.datastorage.SaveableTestData;
import de.dagere.kopeme.junit.rule.KoPeMeBasicStatement4;
import de.dagere.kopeme.runnables.TestRunnable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.runners.model.FrameworkMethod;

public class PerformanceMethodStatement
extends KoPeMeBasicStatement4 {
    private static final Logger LOG = LogManager.getLogger(PerformanceMethodStatement.class);
    protected final String className;
    protected final String methodName;
    protected Finishable mainRunnable;

    public PerformanceMethodStatement(TestRunnable runnables, String filename, Class<?> calledClass, FrameworkMethod method, boolean saveValuesClass) {
        super(runnables, method.getMethod(), filename, method.getName());
        if (saveValuesClass) {
            this.configuration.setSaveValues(saveValuesClass);
        }
        this.methodName = method.getName();
        this.className = calledClass.getSimpleName();
        this.initializeKieker(this.clazzname, method.getName());
    }

    public void evaluate() throws Throwable {
        this.mainRunnable = new Finishable(){

            public void run() {
                try {
                    PerformanceMethodStatement.this.runWarmup();
                    TestResult tr = PerformanceMethodStatement.this.executeSimpleTest(PerformanceMethodStatement.this.annotation.iterations());
                    tr.checkValues();
                    if (!PerformanceMethodStatement.this.assertationvalues.isEmpty()) {
                        LOG.info("Checking: " + PerformanceMethodStatement.this.assertationvalues.size());
                        tr.checkValues(PerformanceMethodStatement.this.assertationvalues);
                    }
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        e.printStackTrace();
                        throw (RuntimeException)e;
                    }
                    if (e instanceof InterruptedException) {
                        throw new RuntimeException(e);
                    }
                    LOG.error("Caught Exception: {}", (Object)e.getLocalizedMessage());
                    e.printStackTrace();
                }
                catch (Throwable t) {
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    LOG.error("Unknown Type: " + t.getClass() + " " + t.getLocalizedMessage());
                }
            }

            public void setFinished(boolean isFinished) {
                PerformanceMethodStatement.this.isFinished = isFinished;
            }

            public boolean isFinished() {
                return PerformanceMethodStatement.this.isFinished;
            }
        };
        if (!this.isFinished) {
            TimeBoundExecution tbe = new TimeBoundExecution(this.mainRunnable, this.annotation.timeout(), TimeBoundExecution.Type.METHOD, this.annotation.useKieker());
            tbe.execute();
        }
        LOG.debug("Timebounded execution finished");
    }

    protected TestResult executeSimpleTest(int executions) throws Throwable {
        TestResult tr = new TestResult(this.methodName, executions, this.datacollectors, false);
        if (!PerformanceTestUtils.checkCollectorValidity((TestResult)tr, (Map)this.assertationvalues, (Map)this.maximalRelativeStandardDeviation)) {
            LOG.warn("Not all Collectors are valid!");
        }
        try {
            this.runMainExecution(tr, "iteration ", executions, this.configuration.getRepetitions());
        }
        catch (Throwable t) {
            tr.finalizeCollection(t);
            PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createErrorTestData((String)this.methodName, (String)this.clazzname, (TestResult)tr, (RunConfiguration)this.configuration));
            throw t;
        }
        tr.finalizeCollection();
        PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createFineTestData((String)this.methodName, (String)this.clazzname, (TestResult)tr, (RunConfiguration)this.configuration));
        return tr;
    }

    private void runWarmup() throws Throwable {
        TestResult tr = new TestResult(this.methodName, this.annotation.warmup(), this.datacollectors, true);
        if (!PerformanceTestUtils.checkCollectorValidity((TestResult)tr, (Map)this.assertationvalues, (Map)this.maximalRelativeStandardDeviation)) {
            LOG.warn("Not all Collectors are valid!");
        }
        try {
            this.runMainExecution(tr, "warmup iteration ", this.annotation.warmup(), this.configuration.getRepetitions());
        }
        catch (Throwable t) {
            t.printStackTrace();
            tr.finalizeCollection(t);
            throw t;
        }
        tr.finalizeCollection();
    }

    public void setFinished(boolean isFinished) {
        LOG.debug("Setting finished: " + isFinished + " " + this.mainRunnable);
        if (this.mainRunnable != null) {
            this.mainRunnable.setFinished(isFinished);
        }
    }
}

