/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.datacollection.TestResult;
import io.github.terahidro2003.measurement.executor.SjswInterProcessExecutor;
import io.github.terahidro2003.measurement.executor.asprof.AsprofInterProcessExecutor;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SamplingHandler {
    private static final Logger LOG = LogManager.getLogger(SamplingHandler.class);
    private final PerformanceTest annotation;
    private List<File> samplingResultFiles;
    private SjswInterProcessExecutor measurementProcessor;
    private final String warmupString;

    public SamplingHandler(PerformanceTest annotation, String warmupString, int executions) {
        this.annotation = annotation;
        this.warmupString = warmupString;
        if (annotation.useSampling() && !warmupString.contains("warmup") && !annotation.samplingResultsFolder().contains("<NULL>")) {
            LOG.info("KoPeMe with sampling enabled.");
            this.measurementProcessor = new AsprofInterProcessExecutor();
            File samplingResultsFolder = new File(annotation.samplingResultsFolder());
            this.samplingResultFiles = this.measurementProcessor.prepareForIterativeMeasurements(samplingResultsFolder, executions);
        }
    }

    public void handleSamplingStart(TestResult tr, int execution) {
        if (this.annotation.useSampling() && !this.warmupString.contains("warmup") && !this.annotation.samplingResultsFolder().contains("<NULL>") && this.measurementProcessor != null && this.samplingResultFiles != null) {
            this.measurementProcessor.measure(this.samplingResultFiles.get(execution - 1), this.annotation.samplingInterval(), new String[]{tr.getTestcase()});
            LOG.info("Collecting iteration {} samples", (Object)execution);
        }
    }

    public void handleSamplingEnd() {
        if (this.annotation.useSampling() && !this.warmupString.contains("warmup") && !this.annotation.samplingResultsFolder().contains("<NULL>") && this.measurementProcessor != null && this.samplingResultFiles != null) {
            try {
                this.measurementProcessor.stopMeasure();
            }
            catch (IllegalStateException e) {
                LOG.error("Tried to stop non-running profiler. Ignoring this measurement", (Throwable)e);
            }
        }
    }
}

