/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.testrunner.time;

import de.dagere.kopeme.Finishable;
import de.dagere.kopeme.TimeBoundExecution;
import de.dagere.kopeme.datacollection.DataCollectorList;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.junit.testrunner.PerformanceMethodStatement;
import de.dagere.kopeme.runnables.TestRunnable;
import java.util.LinkedList;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.runners.model.FrameworkMethod;

public class TimeBasedStatement
extends PerformanceMethodStatement {
    private static final Logger LOG = LogManager.getLogger(TimeBasedStatement.class);
    private static final long NANOTOMIKRO = 1000L;
    private final long duration;

    public TimeBasedStatement(TestRunnable callee, String filename, Class<?> calledClass, FrameworkMethod method, boolean saveFullData) {
        super(callee, filename, calledClass, method, saveFullData);
        this.duration = (long)this.annotation.duration() * 1000L;
    }

    @Override
    public void evaluate() throws Throwable {
        this.mainRunnable = new Finishable(){

            public void run() {
                try {
                    int executions = TimeBasedStatement.this.calibrateMeasurement(TimeBasedStatement.this.className, TimeBasedStatement.this.method.getName() + " warmup", new TestResult(TimeBasedStatement.this.method.getName(), 1, DataCollectorList.ONLYTIME, true), TimeBasedStatement.this.duration, TimeBasedStatement.this.configuration.getRepetitions());
                    TestResult tr = TimeBasedStatement.this.executeSimpleTest(executions);
                    tr.checkValues();
                    if (!TimeBasedStatement.this.assertationvalues.isEmpty()) {
                        LOG.info("Checking: " + TimeBasedStatement.this.assertationvalues.size());
                        tr.checkValues(TimeBasedStatement.this.assertationvalues);
                    }
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        e.printStackTrace();
                        throw (RuntimeException)e;
                    }
                    if (e instanceof InterruptedException) {
                        throw new RuntimeException(e);
                    }
                    LOG.error("Catched Exception: {}", (Object)e.getLocalizedMessage());
                    e.printStackTrace();
                }
                catch (Throwable t) {
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    LOG.error("Unknown Type: " + String.valueOf(t.getClass()) + " " + t.getLocalizedMessage());
                }
            }

            public void setFinished(boolean isFinished) {
                TimeBasedStatement.this.isFinished = isFinished;
            }

            public boolean isFinished() {
                return TimeBasedStatement.this.isFinished;
            }
        };
        if (!this.isFinished) {
            TimeBoundExecution tbe = new TimeBoundExecution(this.mainRunnable, this.annotation.timeout(), TimeBoundExecution.Type.METHOD, this.annotation.useKieker());
            tbe.execute();
        }
        LOG.debug("Timebounded execution finished");
    }

    private int calibrateMeasurement(String executionTypName, String name, TestResult tr, long maximumDuration, int repetitions) {
        int executions = 1;
        long calibrationStart = System.nanoTime();
        try {
            long basicDuration;
            long emptyDuration = this.runMainExecutionTimed(tr, executionTypName, 0, 1);
            long calibration = basicDuration = this.runMainExecutionTimed(tr, executionTypName, 1, 1);
            LinkedList<Long> calibrationValues = new LinkedList<Long>();
            while (calibration < maximumDuration / 2L) {
                long value2 = this.runMainExecutionTimed(tr, executionTypName, 1, 1);
                LOG.debug("Adding: {}", (Object)((calibration += value2) / 1000L), (Object)(value2 / 1000L), (Object)(maximumDuration / 1000L));
                calibrationValues.add(value2);
            }
            DescriptiveStatistics statistics = new DescriptiveStatistics();
            calibrationValues.forEach(value -> statistics.addValue((double)value.longValue()));
            LOG.debug("Mean: " + statistics.getMean() / 1000.0 + " " + statistics.getPercentile(20.0) / 1000.0 + " Calibration time: " + calibration / 1000L);
            long halfTime = maximumDuration / 2L;
            double estimatedExecutionDuration = Math.abs(statistics.getMean() - (double)emptyDuration);
            LOG.debug("Estimated Execution Duration: {} Half-Time: {}", (Object)(estimatedExecutionDuration / 1000.0), (Object)(halfTime / 1000L));
            executions = (int)((double)halfTime / ((double)emptyDuration + estimatedExecutionDuration));
            LOG.debug("Executions: {}", (Object)executions, (Object)((double)maximumDuration / statistics.getMean()));
            long calibrationEnd = System.nanoTime();
            LOG.debug("Duration of calibration: {}", (Object)((calibrationEnd - calibrationStart) / 1000L));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return executions;
    }

    private long runMainExecutionTimed(TestResult tr, String warmupString, int executions, int repetitions) throws Throwable {
        long beginTime = System.nanoTime();
        this.runMainExecution(tr, warmupString, executions, repetitions);
        long endTime = System.nanoTime();
        return (endTime - beginTime) / 1000L;
    }
}

