/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit4.rule;

import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.junit.rule.BeforeAfterMethodFinderJUnit4;
import de.dagere.kopeme.junit.rule.KoPeMeRuleStatement4;
import de.dagere.kopeme.runnables.KoPeMeThrowingRunnable;
import de.dagere.kopeme.runnables.TestRunnable;
import de.dagere.kopeme.runnables.TestRunnables;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class KoPeMeRule
implements TestRule {
    private final Object testObject;

    public KoPeMeRule(Object testObject) {
        this.testObject = testObject;
    }

    public Statement apply(final Statement stmt, Description descr) {
        if (descr.isTest()) {
            Method testMethod = null;
            Class<?> testClass = null;
            try {
                LinkedHashMap<String, String> params;
                testClass = this.testObject.getClass();
                String methodDescription = descr.getMethodName();
                int squaredBracketIndex = methodDescription.indexOf(91);
                if (squaredBracketIndex != -1) {
                    String methodName = methodDescription.substring(0, squaredBracketIndex);
                    params = this.parseParams(methodDescription, squaredBracketIndex);
                    testMethod = testClass.getMethod(methodName, new Class[0]);
                } else {
                    testMethod = testClass.getMethod(methodDescription, new Class[0]);
                    params = null;
                }
                PerformanceTest annotation = testMethod.getAnnotation(PerformanceTest.class);
                if (annotation != null) {
                    KoPeMeThrowingRunnable testRunnable = new KoPeMeThrowingRunnable(){

                        public void run() throws Throwable {
                            stmt.evaluate();
                        }
                    };
                    List<Method> beforeClassMethod = BeforeAfterMethodFinderJUnit4.getBeforeWithMeasurements(testClass);
                    List<Method> afterClassMethod = BeforeAfterMethodFinderJUnit4.getAfterWithMeasurements(testClass);
                    TestRunnables runnables = new TestRunnables(new RunConfiguration(annotation), testRunnable, testClass, this.testObject, beforeClassMethod, afterClassMethod);
                    KoPeMeRuleStatement4 koPeMeStandardRuleStatement = new KoPeMeRuleStatement4((TestRunnable)runnables, testMethod, testClass.getName(), params);
                    return koPeMeStandardRuleStatement;
                }
                return stmt;
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
                return null;
            }
        }
        return stmt;
    }

    private LinkedHashMap<String, String> parseParams(String methodDescription, int squaredBracketIndex) {
        String indexString = methodDescription.substring(squaredBracketIndex + 1, methodDescription.length() - 1);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("JUNIT_PARAMETERIZED", indexString);
        return params;
    }
}

