/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.Finishable;
import de.dagere.kopeme.PerformanceTestUtils;
import de.dagere.kopeme.TimeBoundExecution;
import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.datastorage.ParamNameHelper;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.datastorage.SaveableTestData;
import de.dagere.kopeme.junit.rule.KoPeMeBasicStatement5;
import de.dagere.kopeme.junit.rule.annotations.ParameterChecker;
import de.dagere.kopeme.runnables.TestRunnable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KoPeMeRuleStatement5
extends KoPeMeBasicStatement5 {
    private static final Logger LOG = LogManager.getLogger(KoPeMeRuleStatement5.class);
    private final TestResult finalResult;
    private final LinkedHashMap<String, String> params;

    public KoPeMeRuleStatement5(TestRunnable runnables, Method method, String filename) {
        super(runnables, method, filename, method.getName());
        this.finalResult = new TestResult(method.getName(), this.annotation.warmup(), this.datacollectors, false);
        this.params = null;
        this.initializeKieker(this.clazzname, method.getName());
    }

    public KoPeMeRuleStatement5(TestRunnable runnables, Method method, String filename, LinkedHashMap<String, String> params) {
        super(runnables, method, filename, params != null ? method.getName() + "(" + ParamNameHelper.paramsToString(params) + ")" : method.getName());
        this.finalResult = new TestResult(method.getName(), this.annotation.warmup(), this.datacollectors, false, params);
        this.params = params;
        if (!ParameterChecker.parameterIndexInvalid((PerformanceTest)this.annotation, params)) {
            String methodFileName = params != null ? method.getName() + "(" + ParamNameHelper.paramsToString(params) + ")" : method.getName();
            this.initializeKieker(this.clazzname, methodFileName);
        }
    }

    public void evaluate() throws Throwable {
        boolean parameterIndexInvalid = ParameterChecker.parameterIndexInvalid((PerformanceTest)this.annotation, this.params);
        if (parameterIndexInvalid) {
            return;
        }
        Finishable finishable = new Finishable(){

            public void run() {
                try {
                    KoPeMeRuleStatement5.this.executeSimpleTest();
                    if (!KoPeMeRuleStatement5.this.assertationvalues.isEmpty()) {
                        KoPeMeRuleStatement5.this.finalResult.checkValues(KoPeMeRuleStatement5.this.assertationvalues);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }

            public boolean isFinished() {
                return KoPeMeRuleStatement5.this.isFinished;
            }

            public void setFinished(boolean isFinished) {
                KoPeMeRuleStatement5.this.isFinished = isFinished;
            }
        };
        TimeBoundExecution tbe = new TimeBoundExecution(finishable, (long)this.annotation.timeout(), TimeBoundExecution.Type.METHOD, this.annotation.useKieker());
        tbe.execute();
        LOG.info("Test {} beendet", (Object)this.clazzname);
    }

    private void executeSimpleTest() throws Throwable {
        if (!PerformanceTestUtils.checkCollectorValidity((TestResult)this.finalResult, (Map)this.assertationvalues, (Map)this.maximalRelativeStandardDeviation)) {
            LOG.warn("Not all Collectors are valid!");
        }
        RunConfiguration configuration = new RunConfiguration(this.annotation);
        try {
            this.runWarmup();
            if (!this.isFinished) {
                this.runMainExecution(this.finalResult, "execution ", this.annotation.iterations(), this.annotation.repetitions());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.finalResult.finalizeCollection(t);
            PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createErrorTestData((String)this.finalResult.getMethodName(), (String)this.clazzname, (TestResult)this.finalResult, (RunConfiguration)configuration));
            throw t;
        }
        this.finalResult.finalizeCollection();
        PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createFineTestData((String)this.finalResult.getMethodName(), (String)this.clazzname, (TestResult)this.finalResult, (RunConfiguration)configuration));
    }

    private void runWarmup() throws Throwable {
        if (this.annotation.warmup() > 0) {
            TestResult deletableResult = new TestResult(this.method.getName(), this.annotation.warmup(), this.datacollectors, true);
            this.runMainExecution(deletableResult, "warmup execution ", this.annotation.warmup(), this.annotation.repetitions());
            deletableResult.deleteTempFile();
        }
    }
}

