/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.OutputStreamUtil;
import de.dagere.kopeme.PerformanceTestUtils;
import de.dagere.kopeme.annotations.MaximalRelativeStandardDeviation;
import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.datacollection.DataCollectorList;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.kieker.KoPeMeKiekerSupport;
import de.dagere.kopeme.runnables.TestRunnable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class KoPeMeBasicStatement5 {
    private static final Logger LOG = LogManager.getLogger(KoPeMeBasicStatement5.class);
    protected Map<String, Double> maximalRelativeStandardDeviation;
    protected Map<String, Long> assertationvalues;
    protected final String clazzname;
    protected Method method;
    protected TestRunnable runnables;
    protected boolean isFinished = false;
    protected DataCollectorList datacollectors;
    protected PerformanceTest annotation;
    protected final RunConfiguration configuration;

    public KoPeMeBasicStatement5(TestRunnable runnables, Method method, String clazzname, String methodFileName) {
        this.runnables = runnables;
        this.clazzname = clazzname;
        this.method = method;
        this.annotation = method.getAnnotation(PerformanceTest.class);
        if ("EXTENDED".equals(this.annotation.dataCollectors())) {
            this.datacollectors = DataCollectorList.EXTENDED;
        } else if ("STANDARD".equals(this.annotation.dataCollectors()) || this.annotation == null) {
            this.datacollectors = DataCollectorList.STANDARD;
        } else if ("ONLYTIME".equals(this.annotation.dataCollectors())) {
            this.datacollectors = DataCollectorList.ONLYTIME;
        } else if ("ONLYTIME_NOGC".equals(this.annotation.dataCollectors())) {
            this.datacollectors = DataCollectorList.ONLYTIME_NOGC;
        } else if ("NONE".equals(this.annotation.dataCollectors())) {
            this.datacollectors = DataCollectorList.NONE;
        } else {
            this.datacollectors = DataCollectorList.ONLYTIME;
            LOG.error("For Datacollectorlist, only STANDARD, ONLYTIME, ONLYTIME_NOGC and NONE are allowed");
        }
        if (this.annotation != null) {
            this.configuration = new RunConfiguration(this.annotation);
            this.maximalRelativeStandardDeviation = new HashMap<String, Double>();
            this.assertationvalues = new HashMap<String, Long>();
            for (MaximalRelativeStandardDeviation maximalRelativeStandardDeviation : this.annotation.deviations()) {
                this.maximalRelativeStandardDeviation.put(maximalRelativeStandardDeviation.collectorname(), maximalRelativeStandardDeviation.maxvalue());
            }
            for (MaximalRelativeStandardDeviation maximalRelativeStandardDeviation : this.annotation.assertions()) {
                this.assertationvalues.put(maximalRelativeStandardDeviation.collectorname(), maximalRelativeStandardDeviation.maxvalue());
            }
        } else {
            LOG.error("No @PerformanceTest-Annotation present!");
            this.configuration = null;
        }
    }

    protected void initializeKieker(String clazzname, String methodFileName) {
        try {
            KoPeMeKiekerSupport.INSTANCE.setKiekerWaitTime(this.annotation.kiekerWaitTime());
            KoPeMeKiekerSupport.INSTANCE.useKieker(this.annotation.useKieker(), clazzname, methodFileName);
        }
        catch (Exception e) {
            System.err.println("kieker has failed!");
            e.printStackTrace();
        }
    }

    protected boolean checkCollectorValidity(TestResult tr) {
        return PerformanceTestUtils.checkCollectorValidity((TestResult)tr, this.assertationvalues, this.maximalRelativeStandardDeviation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runMainExecution(TestResult tr, String warmupString, int iterations, int repetitions) throws Throwable {
        System.gc();
        String fullWarmupStart = "--- Starting " + warmupString + " {}/" + iterations + " ---";
        String fullWarmupStop = "--- Stopping " + warmupString + " {}/" + iterations + " ---";
        tr.beforeRun();
        int iteration = 1;
        try {
            if (this.annotation.redirectToTemp()) {
                this.redirectToTempFile();
            } else if (this.annotation.redirectToNull()) {
                OutputStreamUtil.redirectToNullStream();
            }
            LOG.debug("Executing " + iterations + " " + warmupString);
            for (iteration = 1; iteration <= iterations; ++iteration) {
                if (this.annotation.showStart()) {
                    LOG.debug(fullWarmupStart, (Object)iteration);
                }
                this.runnables.getBeforeRunnable().run();
                tr.startCollection();
                this.runAllRepetitions(repetitions);
                tr.stopCollection();
                this.runnables.getAfterRunnable().run();
                tr.setRealExecutions(iteration - 1);
                if (this.annotation.showStart()) {
                    LOG.debug(fullWarmupStop, (Object)iteration);
                }
                this.checkFinished();
            }
        }
        finally {
            OutputStreamUtil.resetStreams();
        }
        System.gc();
        Thread.sleep(1L);
        LOG.debug("Finished iterations: " + (iteration - 1));
        tr.setRealExecutions(iteration - 1);
    }

    private void redirectToTempFile() throws IOException, FileNotFoundException {
        File tempFile = Files.createTempFile("kopeme", ".txt", new FileAttribute[0]).toFile();
        PrintStream stream = new PrintStream(tempFile);
        System.setOut(stream);
        System.setErr(stream);
    }

    private void runAllRepetitions(int repetitions) throws Throwable {
        for (int repetition = 0; repetition < repetitions; ++repetition) {
            this.runnables.getTestRunnable().run();
        }
    }

    private void checkFinished() throws InterruptedException {
        if (this.isFinished) {
            LOG.debug("Exiting finished thread: {}.", (Object)Thread.currentThread().getName());
            throw new InterruptedException("Test timed out.");
        }
        boolean interrupted = Thread.interrupted();
        LOG.trace("Interrupt state: {}", (Object)interrupted);
        if (interrupted) {
            LOG.debug("Exiting thread.");
            throw new InterruptedException("Test was interrupted and eventually timed out.");
        }
    }
}

