/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit5.extension;

import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.junit.rule.BeforeAfterMethodFinderJUnit5;
import de.dagere.kopeme.junit.rule.KoPeMeExtensionStatement;
import de.dagere.kopeme.junit5.extension.DummyConfiguration;
import de.dagere.kopeme.runnables.KoPeMeThrowingRunnable;
import de.dagere.kopeme.runnables.PreparableTestRunnables;
import de.dagere.kopeme.runnables.TestRunnable;
import de.dagere.kopeme.runnables.TestRunnables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestTemplateInvocationTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.jupiter.engine.support.JupiterThrowableCollectorFactory;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class KoPeMeJUnit5Starter {
    private final ExtensionContext context;
    private final UniqueId currentId = UniqueId.forEngine((String)"junit-jupiter");
    private final Object outerInstance;
    private final Method method;
    private final JupiterConfiguration configuration;
    private LinkedHashMap<String, String> params = null;
    private boolean enabled = true;
    private static Method getTestDescriptorMethod;
    private static final Pattern PATTERN;

    public KoPeMeJUnit5Starter(ExtensionContext context) {
        this.context = context;
        this.outerInstance = context.getTestInstance().get();
        this.method = (Method)context.getTestMethod().get();
        this.configuration = this.getDummyConfiguration();
    }

    public void start() throws Exception {
        TestMethodTestDescriptor descriptor = new TestMethodTestDescriptor(this.currentId, this.outerInstance.getClass(), this.method, this.configuration);
        boolean reinitialize = this.needsReinitialization();
        if (this.enabled) {
            if (reinitialize) {
                this.executeMethodReinitializationTest(descriptor);
            } else {
                this.executeTest(descriptor);
            }
        } else {
            System.out.println("Test has been disabled by chosenIndex");
        }
    }

    private boolean needsReinitialization() {
        boolean reinitialize = false;
        for (Field field : this.outerInstance.getClass().getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                if (!annotation.toString().startsWith("@org.mockito.InjectMocks")) continue;
                reinitialize = true;
            }
        }
        return reinitialize;
    }

    private void executeMethodReinitializationTest(TestMethodTestDescriptor descriptor) {
        JupiterEngineExecutionContext jupiterContext = this.prepareJUnit5Class(descriptor);
        RunConfiguration runConfiguration = new RunConfiguration(this.method.getAnnotation(PerformanceTest.class));
        PreparableTestRunnables runnables = new PreparableTestRunnables(runConfiguration, this.outerInstance.getClass(), descriptor, jupiterContext);
        try {
            KoPeMeExtensionStatement statement = new KoPeMeExtensionStatement((TestRunnable)runnables, this.method, this.outerInstance.getClass().getName(), this.params);
            statement.evaluate();
            if (statement.getThrowable() != null) {
                throw statement.getThrowable();
            }
            ThrowableCollector collector = jupiterContext.getThrowableCollector();
            if (!collector.isEmpty()) {
                throw new RuntimeException("Test caused exception", collector.getThrowable());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Test caused exception", t);
        }
    }

    private void executeTest(final TestMethodTestDescriptor descriptor) {
        final JupiterEngineExecutionContext clazzContext = this.prepareJUnit5Method(descriptor);
        try {
            KoPeMeThrowingRunnable throwingRunnable = new KoPeMeThrowingRunnable(){

                public void run() throws Throwable {
                    descriptor.execute(clazzContext, null);
                }
            };
            Object ownCreatedInstance = clazzContext.getExtensionContext().getTestInstance().get();
            RunConfiguration runConfiguration = new RunConfiguration(this.method.getAnnotation(PerformanceTest.class));
            List<Method> beforeClassMethod = BeforeAfterMethodFinderJUnit5.getBeforeWithMeasurements(this.outerInstance.getClass());
            List<Method> afterClassMethod = BeforeAfterMethodFinderJUnit5.getAfterWithMeasurements(this.outerInstance.getClass());
            TestRunnables runnables = new TestRunnables(runConfiguration, throwingRunnable, this.outerInstance.getClass(), ownCreatedInstance, beforeClassMethod, afterClassMethod);
            KoPeMeExtensionStatement statement = new KoPeMeExtensionStatement((TestRunnable)runnables, this.method, this.outerInstance.getClass().getName(), this.params);
            statement.evaluate();
            if (statement.getThrowable() != null) {
                throw statement.getThrowable();
            }
            ThrowableCollector collector = clazzContext.getThrowableCollector();
            if (!collector.isEmpty()) {
                throw new RuntimeException("Test caused exception", collector.getThrowable());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Test caused exception", t);
        }
    }

    private JupiterEngineExecutionContext prepareJUnit5Class(TestMethodTestDescriptor descriptor) {
        MutableExtensionRegistry extensionRegistry = MutableExtensionRegistry.createRegistryWithDefaultExtensions((JupiterConfiguration)this.configuration);
        JupiterEngineExecutionContext kopemeContext = new JupiterEngineExecutionContext(null, this.configuration).extend().withExtensionRegistry(extensionRegistry).withExtensionContext(this.context).withThrowableCollector(JupiterThrowableCollectorFactory.createThrowableCollector()).build();
        ClassTestDescriptor classDescriptor = new ClassTestDescriptor(this.currentId, this.outerInstance.getClass(), this.configuration);
        JupiterEngineExecutionContext clazzContext = classDescriptor.prepare(kopemeContext);
        clazzContext = this.eventuallyAddParameterContext(descriptor, clazzContext);
        return clazzContext;
    }

    private JupiterEngineExecutionContext prepareJUnit5Method(TestMethodTestDescriptor descriptor) {
        JupiterEngineExecutionContext clazzContext = this.prepareJUnit5Class(descriptor);
        JupiterEngineExecutionContext methodContext = descriptor.prepare(clazzContext);
        return methodContext;
    }

    private JupiterEngineExecutionContext eventuallyAddParameterContext(TestMethodTestDescriptor descriptor, JupiterEngineExecutionContext clazzContext) {
        MethodSource source;
        String parameters;
        TestSource testSource;
        if (descriptor.getSource().isPresent() && (testSource = (TestSource)descriptor.getSource().get()) instanceof MethodSource && (parameters = (source = (MethodSource)testSource).getMethodParameterTypes()).length() != 0) {
            try {
                TestDescriptor testDescriptor = (TestDescriptor)getTestDescriptorMethod.invoke((Object)this.context, new Object[0]);
                if (testDescriptor instanceof TestTemplateInvocationTestDescriptor) {
                    TestTemplateInvocationTestDescriptor testTemplateDescriptor = (TestTemplateInvocationTestDescriptor)testDescriptor;
                    clazzContext = testTemplateDescriptor.prepare(clazzContext);
                    int index = KoPeMeJUnit5Starter.getIndex(testTemplateDescriptor);
                    this.createParams(index);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return clazzContext;
    }

    private void createParams(int index) {
        this.params = new LinkedHashMap();
        this.params.put("JUNIT_PARAMETERIZED", Integer.toString(index));
    }

    public static int getIndex(TestTemplateInvocationTestDescriptor testTemplateDescriptor) {
        String displayName = testTemplateDescriptor.getDisplayName();
        return KoPeMeJUnit5Starter.getIndexFromName(displayName);
    }

    public static int getIndexFromName(String displayName) {
        String index = "0";
        Matcher matcher = PATTERN.matcher(displayName);
        if (matcher.lookingAt()) {
            index = matcher.group(1);
        }
        return Integer.parseInt(index);
    }

    private JupiterConfiguration getDummyConfiguration() {
        DummyConfiguration configuration = new DummyConfiguration();
        return configuration;
    }

    static {
        try {
            Class<?> abstractExtensionContextClass = Class.forName("org.junit.jupiter.engine.descriptor.AbstractExtensionContext");
            getTestDescriptorMethod = abstractExtensionContextClass.getDeclaredMethod("getTestDescriptor", new Class[0]);
            getTestDescriptorMethod.setAccessible(true);
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        PATTERN = Pattern.compile("^[^\\d]*(\\d+)");
    }
}

