/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.kopeme.junit.rule;

import de.dagere.kopeme.Finishable;
import de.dagere.kopeme.PerformanceTestUtils;
import de.dagere.kopeme.TimeBoundExecution;
import de.dagere.kopeme.annotations.PerformanceTest;
import de.dagere.kopeme.datacollection.TestResult;
import de.dagere.kopeme.datastorage.ParamNameHelper;
import de.dagere.kopeme.datastorage.RunConfiguration;
import de.dagere.kopeme.datastorage.SaveableTestData;
import de.dagere.kopeme.junit.rule.KoPeMeBasicStatement5;
import de.dagere.kopeme.junit.rule.annotations.ParameterChecker;
import de.dagere.kopeme.runnables.TestRunnable;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KoPeMeExtensionStatement
extends KoPeMeBasicStatement5 {
    private static final Logger LOG = LogManager.getLogger(KoPeMeExtensionStatement.class);
    private final TestResult finalResult;
    private final LinkedHashMap<String, String> params;
    private Throwable throwable = null;

    public KoPeMeExtensionStatement(TestRunnable runnables, Method method, String filename, LinkedHashMap<String, String> params) {
        super(runnables, method, filename);
        this.finalResult = new TestResult(method.getName(), this.annotation.warmup(), this.datacollectors, false, params);
        this.params = params;
        if (!ParameterChecker.parameterIndexInvalid((PerformanceTest)this.annotation, params)) {
            String methodFileName = params != null ? method.getName() + "(" + ParamNameHelper.paramsToString(params) + ")" : method.getName();
            this.initializeKieker(this.clazzname, methodFileName);
        } else {
            this.finalResult.deleteTempFile();
        }
    }

    public void evaluate() {
        boolean parameterIndexInvalid = ParameterChecker.parameterIndexInvalid((PerformanceTest)this.annotation, this.params);
        if (parameterIndexInvalid) {
            return;
        }
        Finishable finishable = new Finishable(){

            public void run() {
                try {
                    KoPeMeExtensionStatement.this.executeSimpleTest();
                    if (!KoPeMeExtensionStatement.this.assertationvalues.isEmpty()) {
                        KoPeMeExtensionStatement.this.finalResult.checkValues(KoPeMeExtensionStatement.this.assertationvalues);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    KoPeMeExtensionStatement.this.throwable = e;
                }
            }

            public boolean isFinished() {
                return KoPeMeExtensionStatement.this.isFinished;
            }

            public void setFinished(boolean isFinished) {
                KoPeMeExtensionStatement.this.isFinished = isFinished;
            }
        };
        TimeBoundExecution tbe = new TimeBoundExecution(finishable, this.annotation.timeout(), TimeBoundExecution.Type.METHOD, this.annotation.useKieker());
        tbe.execute();
        LOG.info("Test {} beendet", (Object)this.clazzname);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    private void executeSimpleTest() throws Throwable {
        if (!PerformanceTestUtils.checkCollectorValidity((TestResult)this.finalResult, (Map)this.assertationvalues, (Map)this.maximalRelativeStandardDeviation)) {
            LOG.warn("Not all Collectors are valid!");
        }
        RunConfiguration configuration = new RunConfiguration(this.annotation);
        try {
            this.runWarmup();
            if (!this.isFinished) {
                this.runMainExecution(this.finalResult, "iteration ", this.annotation.iterations(), this.annotation.repetitions());
            }
        }
        catch (AssertionError ae) {
            this.finalResult.finalizeCollection((Throwable)((Object)ae));
            PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createAssertFailedTestData((String)this.finalResult.getMethodName(), (String)this.clazzname, (TestResult)this.finalResult, (RunConfiguration)configuration));
            throw ae;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.finalResult.finalizeCollection(t);
            PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createErrorTestData((String)this.finalResult.getMethodName(), (String)this.clazzname, (TestResult)this.finalResult, (RunConfiguration)configuration));
            throw t;
        }
        this.finalResult.finalizeCollection();
        PerformanceTestUtils.saveData((SaveableTestData)SaveableTestData.createFineTestData((String)this.finalResult.getMethodName(), (String)this.clazzname, (TestResult)this.finalResult, (RunConfiguration)configuration));
    }

    private void runWarmup() throws Throwable {
        if (this.annotation.warmup() > 0) {
            TestResult deletableResult = new TestResult(this.method.getName(), this.annotation.warmup(), this.datacollectors, true);
            this.runMainExecution(deletableResult, "warmup iteration ", this.annotation.warmup(), this.annotation.repetitions());
            deletableResult.deleteTempFile();
        }
    }
}

