/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.parameters.ExecutionConfigMixin;
import de.dagere.peass.dependency.ExecutorCreator;
import de.dagere.peass.dependency.KiekerResultManager;
import de.dagere.peass.dependency.RTSTestTransformerBuilder;
import de.dagere.peass.dependency.TestFinder;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.TestTransformer;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import picocli.CommandLine;

@CommandLine.Command(description={"Get the traces of the project"}, name="getTraces")
public class GetTraceStarter
implements Callable<Void> {
    @CommandLine.Option(names={"-project", "--project"}, description={"Project folder path"})
    File projectFolder;
    @CommandLine.Mixin
    ExecutionConfigMixin executionConfigMixin;

    public static void main(String[] args) {
        try {
            CommandLine commandLine = new CommandLine((Object)new GetTraceStarter());
            commandLine.execute(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Void call() throws Exception {
        PeassFolders folders = new PeassFolders(this.projectFolder);
        GitUtils.goToCommit(this.executionConfigMixin.getStartcommit(), this.projectFolder);
        this.createTraces(folders);
        FileUtils.moveDirectory((File)folders.getTempDir(), (File)new File(folders.getPeassFolder(), this.executionConfigMixin.getStartcommit() + "_init"));
        FileUtils.moveDirectory((File)folders.getTempMeasurementFolder(), (File)new File(folders.getPeassFolder(), this.executionConfigMixin.getStartcommit() + "_main"));
        GitUtils.goToCommit(this.executionConfigMixin.getEndcommit(), this.projectFolder);
        this.createTraces(folders);
        FileUtils.moveDirectory((File)folders.getTempDir(), (File)new File(folders.getPeassFolder(), this.executionConfigMixin.getEndcommit() + "_init"));
        FileUtils.moveDirectory((File)folders.getTempMeasurementFolder(), (File)new File(folders.getPeassFolder(), this.executionConfigMixin.getEndcommit() + "_main"));
        return null;
    }

    private void createTraces(PeassFolders folders) throws IOException {
        KiekerConfig kiekerConfig = new KiekerConfig(true);
        kiekerConfig.setUseAggregation(false);
        ExecutionConfig executionConfig = this.executionConfigMixin.getExecutionConfig();
        KiekerResultManager tracereader = new KiekerResultManager(folders, executionConfig, kiekerConfig, new EnvironmentVariables());
        TestTransformer transformer = RTSTestTransformerBuilder.createTestTransformer(folders, executionConfig, kiekerConfig);
        TestExecutor executor = ExecutorCreator.createExecutor(folders, transformer, new EnvironmentVariables());
        ModuleClassMapping mapping = new ModuleClassMapping(executor);
        executor.loadClasses();
        TestFinder testFinder = new TestFinder(executor);
        TestSet tests = testFinder.findIncludedTests(mapping);
        tracereader.executeKoPeMeKiekerRun(tests, "1", folders.getDependencyLogFolder());
    }
}

