/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.config.parameters.TestSelectionConfigMixin;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.statistics.DependencyStatisticAnalyzer;
import de.dagere.peass.dependency.statistics.DependencyStatistics;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import picocli.CommandLine;

@CommandLine.Command(description={"Reads the statistics of static selection files"}, name="readSelectionStatistics")
public class RegressionTestSelectionSummarizer
implements Callable<Void> {
    @CommandLine.Mixin
    private TestSelectionConfigMixin config;

    public static void main(String[] args) {
        try {
            CommandLine commandLine = new CommandLine((Object)new RegressionTestSelectionSummarizer());
            commandLine.execute(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Void call() throws Exception {
        File folder = this.config.getResultBaseFolder();
        this.getExtendedTable(folder);
        System.out.println("====");
        this.getSimpleTable(folder);
        return null;
    }

    private void getSimpleTable(File folder) throws IOException, JsonParseException, JsonMappingException {
        System.out.println("Project & Versions & Tests & SIC & TIC\\");
        for (File xmlFile : FileUtils.listFiles((File)folder, (IOFileFilter)new WildcardFileFilter("staticTestSelection_*.json"), (IOFileFilter)TrueFileFilter.INSTANCE)) {
            String projektName = xmlFile.getName().replace("staticTestSelection_", "").replace(".xml", "");
            File executeFile = new File(xmlFile.getParentFile(), "views_" + projektName + "/execute" + projektName + ".json");
            if (!xmlFile.exists() || !executeFile.exists()) continue;
            ExecutionData changedTests = (ExecutionData)Constants.OBJECTMAPPER.readValue(executeFile, ExecutionData.class);
            DependencyStatistics statistics = DependencyStatisticAnalyzer.getChangeStatistics(xmlFile, changedTests);
            double percent = 10000.0 * (double)statistics.getChangedTraceTests() / (double)statistics.getOverallRunTests();
            System.out.println(percent);
            System.out.println(projektName + " & " + statistics.getSize() + " & " + statistics.getOverallRunTests() + " & " + statistics.getPruningRunTests() + " & " + statistics.getChangedTraceTests() + " & " + (double)Math.round(percent) / 100.0 + " %\\");
        }
    }

    private void getExtendedTable(File folder) throws IOException, JsonParseException, JsonMappingException {
        System.out.println("Project;Versions;Normal-Tests;SIC;TIC; Tests once changed; Tests multiple times changed");
        for (File xmlFile : FileUtils.listFiles((File)folder, (IOFileFilter)new WildcardFileFilter("staticTestSelection_*.json"), (IOFileFilter)TrueFileFilter.INSTANCE)) {
            String projektName = xmlFile.getName().replace("staticTestSelection_", "").replace(".xml", "");
            File executeFile = new File(xmlFile.getParentFile(), "views_" + projektName + "/execute" + projektName + ".json");
            if (!xmlFile.exists() || !executeFile.exists()) continue;
            ExecutionData changedTests = (ExecutionData)Constants.OBJECTMAPPER.readValue(executeFile, ExecutionData.class);
            DependencyStatistics statistics = DependencyStatisticAnalyzer.getChangeStatistics(xmlFile, changedTests);
            System.out.println(projektName + ";" + statistics.getSize() + ";" + statistics.getOverallRunTests() + ";" + statistics.getPruningRunTests() + ";" + statistics.getChangedTraceTests() + ";" + statistics.getOnceChangedTests().size() + ";" + statistics.getMultipleChangedTest().size());
        }
    }
}

