/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass;

import de.dagere.peass.analysis.properties.PropertyReader;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.parameters.ExecutionConfigMixin;
import de.dagere.peass.config.parameters.KiekerConfigMixin;
import de.dagere.peass.config.parameters.TestSelectionConfigMixin;
import de.dagere.peass.dependency.parallel.PartialSelectionResultsMerger;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.reader.DependencyParallelReader;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.dependencyprocessors.VersionComparator;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.vcs.CommitUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(description={"Executes the regression test selection. Creates the executionfile, which defines the tests-commit-pairs that need to be executed in each commit"}, name="select")
public class SelectStarter
implements Callable<Void> {
    private static final Logger LOG = LogManager.getLogger(SelectStarter.class);
    @CommandLine.Mixin
    private TestSelectionConfigMixin config;
    @CommandLine.Mixin
    private KiekerConfigMixin kiekerConfigMixin;
    @CommandLine.Mixin
    private ExecutionConfigMixin executionConfigMixin;

    public static void main(String[] args) {
        try {
            CommandLine commandLine = new CommandLine((Object)new SelectStarter());
            commandLine.execute(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Void call() throws Exception {
        String project = this.config.getProjectFolder().getName();
        List<String> commits = CommitUtil.getGitCommits(this.executionConfigMixin.getStartcommit(), this.executionConfigMixin.getEndcommit(), this.config.getProjectFolder(), this.executionConfigMixin.isLinearizeHistory());
        VersionComparator.setVersions(commits);
        CommitComparatorInstance comparator = new CommitComparatorInstance(commits);
        this.readExecutions(project, comparator);
        return null;
    }

    public void readExecutions(String project, CommitComparatorInstance comparator) throws InterruptedException, IOException {
        KiekerConfig kiekerConfig = this.kiekerConfigMixin.getKiekerConfig();
        ExecutionConfig executionConfig = this.executionConfigMixin.getExecutionConfig();
        DependencyParallelReader reader = new DependencyParallelReader(this.config.getProjectFolder(), this.config.getResultBaseFolder(), project, comparator, this.config.getDependencyConfig(), executionConfig, kiekerConfig, new EnvironmentVariables(executionConfig.getProperties()));
        Object[] outFiles = reader.readDependencies();
        LOG.debug("Files: {}", (Object)Arrays.toString(outFiles));
        ResultsFolders mergedFolders = new ResultsFolders(this.config.getResultBaseFolder(), project);
        ExecutionData executionData = PartialSelectionResultsMerger.mergePartialData(comparator, (ResultsFolders[])outFiles, mergedFolders);
        PeassFolders folders = new PeassFolders(this.config.getProjectFolder());
        File dependencyTempFiles = new File(folders.getTempProjectFolder().getParentFile(), "dependencyTempFiles");
        FileUtils.moveDirectory((File)folders.getTempProjectFolder(), (File)dependencyTempFiles);
        if (!this.config.isDoNotGenerateProperties()) {
            this.generateProperties(project, executionConfig, folders, executionData);
        }
    }

    private void generateProperties(String project, ExecutionConfig executionConfig, PeassFolders folders, ExecutionData executionData) throws IOException {
        ResultsFolders resultsFolders = new ResultsFolders(this.config.getResultBaseFolder(), project);
        PeassFolders propertyFolder = folders.getTempFolder("propertyReadFolder", this.executionConfigMixin.getGitCryptKey());
        PropertyReader propertyReader = new PropertyReader(resultsFolders, propertyFolder.getProjectFolder(), executionData, executionConfig);
        propertyReader.readAllTestsProperties();
        FileUtils.forceDelete((File)propertyFolder.getProjectFolder());
    }
}

