/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.analysis.properties;

import de.dagere.nodeDiffDetector.data.MethodCall;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.FileUtils;

public class ChangedMethodManager {
    private static final String DIFF_MODIFIER = "diff";
    private static final String OLD_MODIFIER = "old";
    private static final String MAIN_MODIFIER = "main";
    private final File methodSourceFolder;

    public ChangedMethodManager(File methodSourceFolder) {
        this.methodSourceFolder = methodSourceFolder;
    }

    public File getMethodMainFile(String commit, MethodCall methodEntity) {
        return this.getMethodModifierFile(commit, methodEntity, MAIN_MODIFIER);
    }

    public File getMethodOldFile(String commit, MethodCall methodEntity) {
        return this.getMethodModifierFile(commit, methodEntity, OLD_MODIFIER);
    }

    public File getMethodDiffFile(String commit, MethodCall methodEntity) {
        return this.getMethodModifierFile(commit, methodEntity, DIFF_MODIFIER);
    }

    private File getMethodModifierFile(String commit, MethodCall methodEntity, String modifier) {
        File commitFolder = new File(this.methodSourceFolder, commit);
        commitFolder.mkdirs();
        String clazzFolderName = methodEntity.getModule() != null && !methodEntity.getModule().equals("") ? methodEntity.getModule() + "\u00a7" + methodEntity.getJavaClazzName() : methodEntity.getJavaClazzName();
        File clazzFolder = new File(commitFolder, clazzFolderName);
        clazzFolder.mkdirs();
        String methodFilename = methodEntity.getMethod().replace("<", "(").replace(">", ")");
        String methodString = methodFilename + "_" + methodEntity.getParametersPrintable();
        String filename = methodString + "_" + modifier + ".txt";
        if (filename.length() > 128) {
            File mappingFile = new File(clazzFolder, "mapping.txt");
            File resultFile = ChangedMethodManager.readInMappingFile(clazzFolder, methodString, mappingFile, modifier);
            if (resultFile != null) {
                return resultFile;
            }
            File methodFileCandidate = ChangedMethodManager.searchUnusedFilename(modifier, clazzFolder, methodFilename);
            ChangedMethodManager.updateMappingFile(methodString, mappingFile, methodFileCandidate);
            return methodFileCandidate;
        }
        File methodDiffFile = new File(clazzFolder, filename);
        return methodDiffFile;
    }

    private static File searchUnusedFilename(String modifier, File clazzFolder, String methodFilename) {
        int candidateIndex = 0;
        File methodFileCandidate = new File(clazzFolder, methodFilename + "_" + candidateIndex + "_" + modifier + ".txt");
        while (methodFileCandidate.exists()) {
            methodFileCandidate = new File(clazzFolder, methodFilename + "_" + ++candidateIndex + "_" + modifier + ".txt");
        }
        return methodFileCandidate;
    }

    private static void updateMappingFile(String methodString, File mappingFile, File methodFileCandidate) {
        try {
            String finalName = methodString + ";" + methodFileCandidate.getName() + "\n";
            Files.write(mappingFile.toPath(), finalName.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File readInMappingFile(File clazzFolder, String methodString, File mappingFile, String modifier) {
        File resultFile = null;
        if (mappingFile.exists()) {
            try {
                String mappingString = FileUtils.readFileToString((File)mappingFile, (Charset)StandardCharsets.UTF_8);
                for (String line : mappingString.split("\n")) {
                    String[] split = line.split(";");
                    if (!split[0].equals(methodString)) continue;
                    String diffFileName = split[1];
                    if (!DIFF_MODIFIER.equals(modifier)) {
                        String pureFilename = diffFileName.substring(0, diffFileName.lastIndexOf(95) + 1);
                        String changedFilename = pureFilename + modifier + ".txt";
                        resultFile = new File(clazzFolder, changedFilename);
                    } else {
                        resultFile = new File(clazzFolder, diffFileName);
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultFile;
    }
}

