/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.analysis.properties;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.dagere.peass.analysis.properties.ChangeProperties;
import de.dagere.peass.analysis.properties.ChangeProperty;
import de.dagere.peass.analysis.properties.PropertyProcessor;
import de.dagere.peass.dependencyprocessors.VersionComparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CommitChangeProperties {
    private Map<String, ChangeProperties> commits = VersionComparator.hasVersions() ? new TreeMap(VersionComparator.INSTANCE) : new LinkedHashMap();

    public Map<String, ChangeProperties> getVersions() {
        return this.commits;
    }

    public void setVersions(Map<String, ChangeProperties> versionProperties) {
        this.commits = versionProperties;
    }

    public void executeProcessor(PropertyProcessor c) {
        for (Map.Entry<String, ChangeProperties> commit : this.commits.entrySet()) {
            for (Map.Entry<String, List<ChangeProperty>> testcase : commit.getValue().getProperties().entrySet()) {
                for (ChangeProperty change : testcase.getValue()) {
                    c.process(commit.getKey(), testcase.getKey(), change, commit.getValue());
                }
            }
        }
    }

    @JsonIgnore
    public int getSourceChanges() {
        Counter counter = new Counter();
        this.executeProcessor(counter);
        return counter.count;
    }

    final class Counter
    implements PropertyProcessor {
        int count = 0;

        Counter() {
        }

        @Override
        public void process(String commit, String testcase, ChangeProperty change, ChangeProperties changeProperties) {
            if (change.isAffectsSource() && !change.isAffectsTestSource()) {
                ++this.count;
            }
        }
    }
}

