/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.analysis.properties;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.Patch;
import de.dagere.nodeDiffDetector.config.FolderConfig;
import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.sourceReading.MethodReader;
import de.dagere.peass.analysis.properties.ChangedMethodManager;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.dependency.traces.diff.DiffUtilJava;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;

public class MethodChangeReader {
    private final ChangedMethodManager manager;
    private final MethodCall clazz;
    private final String commit;
    private final String method;
    private final String methodOld;

    public MethodChangeReader(File methodSourceFolder, File sourceFolder, File oldSourceFolder, MethodCall clazz, String commit, ExecutionConfig config) throws FileNotFoundException {
        this.manager = new ChangedMethodManager(methodSourceFolder);
        this.clazz = clazz;
        this.commit = commit;
        this.method = MethodReader.getMethodSource((File)sourceFolder, (MethodCall)clazz, (FolderConfig)config);
        this.methodOld = MethodReader.getMethodSource((File)oldSourceFolder, (MethodCall)clazz, (FolderConfig)config);
    }

    public void readMethodChangeData() throws IOException {
        File goalFile = this.manager.getMethodDiffFile(this.commit, this.clazz);
        if (!this.method.equals(this.methodOld)) {
            File main = this.manager.getMethodMainFile(this.commit, this.clazz);
            File old = this.manager.getMethodOldFile(this.commit, this.clazz);
            FileUtils.writeStringToFile((File)main, (String)this.method, (Charset)Charset.defaultCharset());
            FileUtils.writeStringToFile((File)old, (String)this.methodOld, (Charset)Charset.defaultCharset());
            DiffUtilJava.generateDiffFile(goalFile, Arrays.asList(old, main), "");
        } else {
            FileUtils.writeStringToFile((File)goalFile, (String)this.method, (Charset)Charset.defaultCharset());
        }
    }

    public Patch<String> getKeywordChanges(MethodCall clazz) throws FileNotFoundException {
        Patch patch = DiffUtils.diff(Arrays.asList(this.method.split("\n")), Arrays.asList(this.methodOld.split("\n")));
        return patch;
    }
}

