/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.analysis.properties;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.Patch;
import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.nodeDiffDetector.diffDetection.ClazzChangeData;
import de.dagere.peass.analysis.changes.Change;
import de.dagere.peass.analysis.properties.ChangeProperty;
import de.dagere.peass.analysis.properties.MethodChangeReader;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.dependency.ChangeManager;
import de.dagere.peass.dependency.ExecutorCreator;
import de.dagere.peass.dependency.RTSTestTransformerBuilder;
import de.dagere.peass.dependency.analysis.data.CommitDiff;
import de.dagere.peass.dependency.analysis.data.EntityUtil;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.traces.TraceFileManager;
import de.dagere.peass.dependency.traces.diff.TraceFileUtil;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.TestTransformer;
import de.dagere.peass.vcs.CommitIteratorGit;
import de.dagere.peass.vcs.GitUtils;
import de.dagere.requitur.Sequitur;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyReadHelper {
    private static final Logger LOG = LogManager.getLogger(PropertyReadHelper.class);
    public static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "System.out.println", "System.gc", "Thread.sleep"};
    private final ExecutionData changedTests;
    private final Type testClazz;
    private final ExecutionConfig config;
    private final String commit;
    private final String commitOld;
    private final Change change;
    private final File projectFolder;
    private final File viewFolder;
    private final File methodSourceFolder;
    private final PeassFolders folders;
    private final TestTransformer testTransformer;
    private final TestExecutor testExecutor;

    public static void main(String[] args) throws IOException {
        Type ce = new Type("org.apache.commons.fileupload.StreamingTest", "");
        Change change = new Change();
        change.setChangePercent(-8.0);
        change.setMethod("testFILEUPLOAD135");
        File projectFolder2 = new File("../../projekte/commons-fileupload");
        File viewFolder2 = new File("/home/reichelt/daten3/diss/repos/preprocessing/4/commons-fileupload/views_commons-fileupload/");
        FixedCommitConfig demoConfig = new FixedCommitConfig();
        demoConfig.setCommit("96f8f56556a8592bfed25c82acedeffc4872ac1f");
        demoConfig.setCommitOld("09d16c");
        PropertyReadHelper propertyReadHelper = new PropertyReadHelper(new ExecutionConfig(), demoConfig, ce, change, projectFolder2, viewFolder2, new File("/tmp/"), null);
        propertyReadHelper.read();
    }

    public PropertyReadHelper(ExecutionConfig config, FixedCommitConfig commitConfig, Type clazz, Change change, File projectFolder, File viewFolder, File methodSourceFolder, ExecutionData changedTests) {
        this.commit = commitConfig.getCommit();
        this.commitOld = commitConfig.getCommitOld();
        this.config = config;
        this.testClazz = clazz;
        this.change = change;
        this.projectFolder = projectFolder;
        this.viewFolder = viewFolder;
        this.methodSourceFolder = methodSourceFolder;
        this.changedTests = changedTests;
        this.folders = new PeassFolders(projectFolder);
        this.testTransformer = RTSTestTransformerBuilder.createTestTransformer(this.folders, config, new KiekerConfig(true));
        this.testExecutor = ExecutorCreator.createExecutor(this.folders, this.testTransformer, new EnvironmentVariables());
    }

    public ChangeProperty read() throws IOException {
        ChangeProperty property = new ChangeProperty(this.change);
        this.getSourceInfos(property);
        LOG.debug("Comparing " + this.commit + " " + property.getMethod());
        File folder = new File(this.viewFolder, "view_" + this.commit + File.separator + String.valueOf(this.testClazz) + File.separator + property.getMethod());
        if (folder.exists()) {
            return property;
        }
        LOG.error("Folder {} does not exist", (Object)folder);
        return property;
    }

    private String getShortPrevVersion() {
        if (this.commitOld == null) {
            return "";
        }
        if (this.commitOld.endsWith("~1")) {
            return this.commitOld.substring(0, 6) + "~1";
        }
        return this.commitOld.substring(0, 6);
    }

    public void getSourceInfos(ChangeProperty property) throws FileNotFoundException, IOException {
        File folder = new File(this.viewFolder, "view_" + this.commit + File.separator + String.valueOf(this.testClazz) + File.separator + property.getMethod());
        File traceFileCurrent = TraceFileManager.getExistingTraceFile(folder, this.commit.substring(0, 6), "_method");
        File traceFileOld = TraceFileManager.getExistingTraceFile(folder, this.getShortPrevVersion(), "_method");
        if (this.changedTests != null) {
            traceFileOld = this.searchOldTraceFile(property, traceFileOld);
        }
        if (traceFileCurrent.exists() && traceFileOld.exists()) {
            this.analyzeTraceFiles(property, traceFileCurrent, traceFileOld);
        } else {
            this.readExpandedFileTrace(folder);
            if (!traceFileCurrent.exists()) {
                LOG.error("Tracefile not found: {}", (Object)traceFileCurrent);
            } else {
                LOG.error("Tracefile not found: {}", (Object)traceFileOld);
            }
        }
    }

    private void readExpandedFileTrace(File folder) throws IOException, FileNotFoundException {
        File expandedFile = new File(folder, this.commit.substring(0, 6) + "_method_expanded.txt");
        if (expandedFile.exists()) {
            LOG.info("Reading method sources from expanded tracefile {}", (Object)expandedFile);
            List traceCurrent = Sequitur.getExpandedTrace((File)expandedFile);
            PeassFolders folders = new PeassFolders(this.projectFolder);
            this.getChanges(folders);
            this.readMethodSources(new ChangeProperty(), folders, new HashSet<String>(traceCurrent));
        }
    }

    private File searchOldTraceFile(ChangeProperty property, File traceFileOld) {
        ArrayList<String> versions = new ArrayList<String>(this.changedTests.getCommits().keySet());
        int index = versions.indexOf(this.commitOld);
        if (index == -1) {
            index = versions.indexOf(this.commit) - 1;
        }
        LOG.debug("Trying old versions starting with {} Versions: {}", (Object)index, this.changedTests.getCommits().keySet());
        while (!traceFileOld.exists() && index >= 0) {
            String tryVersion = (String)versions.get(index);
            File versionFolder = new File(this.viewFolder, "view_" + tryVersion);
            File predecessorFolder = new File(versionFolder, String.valueOf(this.testClazz) + File.separator + property.getMethod());
            String tryVersionShort = tryVersion.substring(0, 6);
            traceFileOld = TraceFileManager.getExistingTraceFile(predecessorFolder, tryVersionShort, "_method");
            LOG.debug("Trying file " + traceFileOld.getAbsolutePath());
            --index;
        }
        return traceFileOld;
    }

    private void analyzeTraceFiles(ChangeProperty property, File traceFileCurrent, File traceFileOld) throws IOException, FileNotFoundException {
        PeassFolders folders = new PeassFolders(this.projectFolder);
        Map<Type, ClazzChangeData> changes = this.getChanges(folders);
        List traceCurrent = Sequitur.getExpandedTrace(TraceFileUtil.getText(traceFileCurrent));
        List traceOld = Sequitur.getExpandedTrace(TraceFileUtil.getText(traceFileOld));
        PropertyReadHelper.determineTraceSizeChanges(property, traceCurrent, traceOld);
        Set<String> merged = this.getMergedCalls(traceCurrent, traceOld);
        this.readMethodSources(property, folders, merged);
        this.identifyAffectedClasses(property, merged);
        LOG.trace("Calls: " + String.valueOf(merged));
        this.getTestSourceAffection(property, merged, folders, changes);
    }

    private Map<Type, ClazzChangeData> getChanges(PeassFolders folders) {
        List<String> commits = Arrays.asList(this.commit, this.commitOld);
        CommitIteratorGit iterator = new CommitIteratorGit(this.projectFolder, commits, this.commitOld);
        ChangeManager changeManager = new ChangeManager(folders, iterator, this.config, this.testExecutor);
        Map<Type, ClazzChangeData> changes = changeManager.getChanges(this.commitOld, this.commit);
        return changes;
    }

    private void readMethodSources(ChangeProperty property, PeassFolders folders, Set<String> merged) throws FileNotFoundException, IOException {
        for (String calledInOneMethod : merged) {
            LOG.debug("Loading: " + calledInOneMethod);
            MethodCall entity = EntityUtil.determineEntity(calledInOneMethod);
            MethodChangeReader reader = new MethodChangeReader(this.methodSourceFolder, folders.getProjectFolder(), folders.getOldSources(), entity, this.commit, this.config);
            reader.readMethodChangeData();
            this.getKeywordChanges(property, reader, entity);
        }
    }

    private void identifyAffectedClasses(ChangeProperty property, Set<String> calls) throws FileNotFoundException, IOException {
        List<File> modules = this.testExecutor.getModules().getModules();
        CommitDiff diff = GitUtils.getChangedFiles(this.projectFolder, modules, this.commit, this.config);
        this.removeUncalledClasses(calls, diff);
        property.setAffectedClasses(diff.getChangedClasses().size());
        int changedLines = GitUtils.getChangedLines(this.projectFolder, this.commit, diff.getChangedClasses(), this.config);
        property.setAffectedLines(changedLines);
    }

    private void removeUncalledClasses(Set<String> calls, CommitDiff diff) {
        Iterator<Type> it = diff.getChangedClasses().iterator();
        while (it.hasNext()) {
            Type entity = it.next();
            boolean called = false;
            for (String call : calls) {
                if (!call.startsWith(entity.getJavaClazzName())) continue;
                called = true;
                break;
            }
            if (called) continue;
            it.remove();
        }
    }

    public void getKeywordChanges(ChangeProperty property, MethodChangeReader changeManager, MethodCall entity) throws FileNotFoundException {
        Patch<String> patch = changeManager.getKeywordChanges(entity);
        HashMap<String, Integer> vNewkeywords = new HashMap<String, Integer>();
        HashMap<String, Integer> vOldkeywords = new HashMap<String, Integer>();
        for (AbstractDelta abstractDelta : patch.getDeltas()) {
            for (String line : abstractDelta.getSource().getLines()) {
                PropertyReadHelper.getKeywordCount(vOldkeywords, line);
            }
            for (String line : abstractDelta.getTarget().getLines()) {
                PropertyReadHelper.getKeywordCount(vNewkeywords, line);
            }
        }
        for (Map.Entry entry : vNewkeywords.entrySet()) {
            property.getAddedMap().put((String)entry.getKey(), (Integer)entry.getValue());
        }
        for (Map.Entry entry : vOldkeywords.entrySet()) {
            property.getRemovedMap().put((String)entry.getKey(), (Integer)entry.getValue());
        }
    }

    public Set<String> getMergedCalls(List<String> traceCurrent, List<String> traceOld) {
        HashSet<String> merged = new HashSet<String>();
        HashSet<String> calledCurrent = new HashSet<String>(traceCurrent);
        HashSet<String> calledOld = new HashSet<String>(traceOld);
        merged.addAll(calledCurrent);
        merged.addAll(calledOld);
        return merged;
    }

    void getTestSourceAffection(ChangeProperty property, Set<String> calls, PeassFolders folders, Map<Type, ClazzChangeData> changes) throws FileNotFoundException {
        ClazzChangeData clazzChangeData = changes.get(this.testClazz);
        if (clazzChangeData != null) {
            if (clazzChangeData.isOnlyMethodChange()) {
                for (Set set : clazzChangeData.getChangedMethods().values()) {
                    if (!set.contains(property.getMethod())) continue;
                    property.setAffectsTestSource(true);
                }
            } else {
                property.setAffectsTestSource(true);
            }
        }
        for (Map.Entry<Object, Object> entry : changes.entrySet()) {
            Type outerClazz = (Type)entry.getKey();
            if (!((ClazzChangeData)entry.getValue()).isOnlyMethodChange()) {
                for (String string : calls) {
                    String clazzCall = string.substring(0, string.indexOf("#"));
                    if (!outerClazz.getJavaClazzName().equals(clazzCall)) continue;
                    this.processFoundCall(property, entry);
                }
                continue;
            }
            for (Map.Entry entry2 : ((ClazzChangeData)entry.getValue()).getChangedMethods().entrySet()) {
                for (String changedMethod : (Set)entry2.getValue()) {
                    String fqn = changedMethod.contains("#") ? outerClazz.getPackage() + "." + (String)entry2.getKey() + "$" + changedMethod : outerClazz.getPackage() + "." + (String)entry2.getKey() + "#" + changedMethod;
                    if (fqn.contains("(") && ((String)entry2.getKey()).contains("$")) {
                        String innerParameter = ((String)entry2.getKey()).substring(0, ((String)entry2.getKey()).lastIndexOf("$"));
                        fqn = fqn.substring(0, fqn.indexOf("(") + 1) + innerParameter + "," + fqn.substring(fqn.indexOf("(") + 1);
                    }
                    if (!calls.contains(fqn)) continue;
                    this.processFoundCall(property, entry);
                }
            }
        }
    }

    public static void determineTraceSizeChanges(ChangeProperty property, List<String> traceCurrent, List<String> traceOld) throws IOException {
        LOG.debug("Trace sizes: {}, {}", (Object)traceCurrent.size(), (Object)traceOld.size());
        if (traceCurrent.size() + traceOld.size() < 10000) {
            Patch patch = DiffUtils.diff(traceOld, traceCurrent);
            LOG.debug((Object)patch);
            int added = 0;
            int removed = 0;
            for (AbstractDelta delta : patch.getDeltas()) {
                if (delta.getType().equals((Object)DeltaType.DELETE)) {
                    ++removed;
                    continue;
                }
                if (delta.getType().equals((Object)DeltaType.INSERT)) {
                    ++added;
                    continue;
                }
                if (!delta.getType().equals((Object)DeltaType.CHANGE)) continue;
                ++added;
                ++removed;
            }
            if (added > 0 && removed > 0) {
                property.setTraceChangeType(ChangeProperty.TraceChange.BOTH);
            } else if (added > 0) {
                property.setTraceChangeType(ChangeProperty.TraceChange.ADDED_CALLS);
            } else if (removed > 0) {
                property.setTraceChangeType(ChangeProperty.TraceChange.REMOVED_CALLS);
            } else {
                property.setTraceChangeType(ChangeProperty.TraceChange.NO_CALL_CHANGE);
            }
        } else {
            property.setTraceChangeType(ChangeProperty.TraceChange.UNKNOWN);
        }
        property.setCalls(traceCurrent.size());
        property.setCallsOld(traceOld.size());
    }

    private void processFoundCall(ChangeProperty property, Map.Entry<Type, ClazzChangeData> changedEntity) {
        Type call = changedEntity.getKey();
        if (call.getClazz().toLowerCase().contains("test")) {
            property.setAffectsTestSource(true);
        } else {
            property.setAffectsSource(true);
        }
        String packageName = call.getPackage();
        for (Map.Entry methods : changedEntity.getValue().getChangedMethods().entrySet()) {
            if (methods.getValue() != null && ((Set)methods.getValue()).size() > 0) {
                for (String method : (Set)methods.getValue()) {
                    property.getAffectedMethods().add(packageName + "." + (String)methods.getKey() + "#" + method);
                }
                continue;
            }
            property.getAffectedMethods().add(call.getJavaClazzName());
        }
    }

    private static void getKeywordCount(Map<String, Integer> v1keywords, String line) {
        for (String keyword : keywords) {
            if (!line.contains(keyword)) continue;
            Integer integer = v1keywords.get(keyword);
            int count = integer != null ? integer : 0;
            v1keywords.put(keyword, count + 1);
        }
    }
}

