/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.analysis.properties;

import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.analysis.changes.Change;
import de.dagere.peass.analysis.properties.ChangeProperties;
import de.dagere.peass.analysis.properties.ChangeProperty;
import de.dagere.peass.analysis.properties.CommitChangeProperties;
import de.dagere.peass.analysis.properties.PropertyReadHelper;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyReader {
    private static final Logger LOG = LogManager.getLogger(PropertyReader.class);
    private final ResultsFolders resultsFolders;
    private final File projectFolder;
    private final ExecutionData changedTests;
    private int count = 0;
    private final ExecutionConfig config;

    public PropertyReader(ResultsFolders resultsFolders, File projectFolder, ExecutionData changedTests, ExecutionConfig config) {
        this.resultsFolders = resultsFolders;
        this.projectFolder = projectFolder;
        this.changedTests = changedTests;
        this.config = config;
    }

    public void readAllTestsProperties() {
        try {
            CommitChangeProperties commitProperties = new CommitChangeProperties();
            File methodFolder = new File(this.resultsFolders.getPropertiesFolder(), "methods");
            methodFolder.mkdirs();
            for (Map.Entry<String, TestSet> commit : this.changedTests.getCommits().entrySet()) {
                this.readCommit(commitProperties, methodFolder, commit);
                Constants.OBJECTMAPPER.writeValue(this.resultsFolders.getPropertiesFile(), (Object)commitProperties);
            }
            LOG.info("Analyzed properties: " + this.count);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readCommit(CommitChangeProperties commitProperties, File methodFolder, Map.Entry<String, TestSet> commit) throws IOException {
        LOG.debug("Reading {}", (Object)commit.getKey());
        ChangeProperties changeProperties = new ChangeProperties();
        changeProperties.setCommitText(GitUtils.getCommitText(this.projectFolder, commit.getKey()));
        changeProperties.setCommitter(GitUtils.getCommitter(this.projectFolder, commit.getKey()));
        commitProperties.getVersions().put(commit.getKey(), changeProperties);
        for (Map.Entry<TestClazzCall, Set<String>> testclazz : commit.getValue().getTestcases().entrySet()) {
            LinkedList<ChangeProperty> properties = new LinkedList<ChangeProperty>();
            changeProperties.getProperties().put(testclazz.getKey().getClazz(), properties);
            for (String testmethod : testclazz.getValue()) {
                this.readMethod(methodFolder, commit, testclazz, properties, testmethod);
            }
        }
    }

    private void readMethod(File methodSourceFolder, Map.Entry<String, TestSet> commit, Map.Entry<TestClazzCall, Set<String>> testclazz, List<ChangeProperty> properties, String testmethod) throws IOException {
        Change testcaseChange = new Change();
        testcaseChange.setMethod(testmethod);
        Type entity = new Type(testclazz.getKey().getClazz(), testclazz.getKey().getModule());
        FixedCommitConfig copyConfig = new FixedCommitConfig();
        copyConfig.setCommit(commit.getKey());
        copyConfig.setCommitOld(commit.getValue().getPredecessor());
        PropertyReadHelper reader = new PropertyReadHelper(this.config, copyConfig, entity, testcaseChange, this.projectFolder, this.resultsFolders.getViewFolder(), methodSourceFolder, this.changedTests);
        ChangeProperty currentProperty = reader.read();
        if (currentProperty != null) {
            properties.add(currentProperty);
        }
        ++this.count;
    }
}

